package com.biz.interfacedocker.orderdocker.service;

import com.biz.interfacedocker.orderdocker.vo.DeliveryEfficiencyVo;
import java.sql.Date;

/**
 * OmsSearchSellingInfoApiService
 * Description: 从中台查询门店用户，销售数据接口
 *
 * @author: weitongyan
 * @date: 08/Dec/2017 15:36
 */

public interface OmsSearchSellingInfoApiService {

    /**
     * 查询某月某店下单用户量
     *
     * @param month 月份
     * @param shopBn 店铺编码
     */
    Integer searchOrderedUserNumByMonth(Date month, String shopBn);

    /**
     * 查询某月某店注册用户量
     *
     * @param month 月份
     * @param shopBn 店铺编码
     */
    Integer searchRegisterUserNumByMonth(Date month, String shopBn);

    /**
     * 查询某月某店用户复购率
     *
     * @param month 月份
     * @param shopBn 店铺编码
     */
    Double searchReShopRateByMonth(Date month, String shopBn);

    /**
     * 查询某日某店销售额
     *
     * @param day 日期
     * @param shopBn 店铺编码
     */
    Double searchSellingAmountByDay(Date day, String shopBn);

    /**
     * 查询某个时间段的某店配送时效
     *
     * @param leftBoundary 时间段左边界
     * @param rightBoundary 时间段右边界
     * @param shopBn 店铺编码
     * @return 配送时效
     */
    DeliveryEfficiencyVo searchDeliveryEfficiency(Date leftBoundary, Date rightBoundary, String shopBn);
}
