/**
 * 
 */
package com.biz.interfacedocker.productdocker.service;

import java.math.BigDecimal;
import java.util.List;

import com.biz.interfacedocker.common.page.PageInfo;
import com.biz.interfacedocker.productdocker.vo.ProductAreaPriceVo;

/**
 * @author yangshuo
 * 商品会员价格接口
 *
 */
public interface ProductAreaPriceApiService {
	
	/**
	 * 查询商品价格
	 * @param bpmcu 区域编号 必填
	 * @param sn 商品长编码 (与bpmcu两者取一)
	 * @param bpitm 商品短编码 (与sn两者取一)
	 * @param level 会员等级 必填
	 * @param unit  包装单位 必填
	 * @return
	 */
	public ProductAreaPriceVo getProductPrice(String bpmcu,String sn,Long bpitm,Integer level,String unit);
	
	
	/**
	 * 根据门店编号以及商品编号 查询商品价格
	 * 查询商品价格
	 * @Title: getProductPrice 
	 * @param storeNo 门店编号 必填
	 * @param sn 商品编号 必填
	 * @return List<ProductAreaPriceVo>
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月31日 下午10:21:13
	 */
	public List<ProductAreaPriceVo> getProductPrice(String storeNo,String sn);
	
	
	/**
	 * 商品价格查询
	 * @Title: getProductPrice 
	 * @param productNo 商品编号 
	 * @param productName 商品名称 选填
	 * @param level 会员等级
	 * @param minPrice 最小零售价 选填
	 * @param maxPrice 最大零售价 选填
	 * @param bigType 商品大类型 选填
	 * @param subType 商品小类型 选填
	 * @param belongareacode 区域编码  选填
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年6月16日 下午1:59:45
	 */
	public List<ProductAreaPriceVo> getProductPrice(String productNo,String productName,Integer level,BigDecimal minPrice,BigDecimal maxPrice,String bigType,String subType,String ...belongareacode);

	/**
	 * 商品价格查询 分页
	 * @Title: getProductPrice 
	 * @param pageInfo 分页信息
	 * @param productNo 商品编号 
	 * @param productName 商品名称 选填
	 * @param level 会员等级
	 * @param minPrice 最小零售价 选填
	 * @param maxPrice 最大零售价 选填
	 * @param bigType 商品大类型 选填
	 * @param subType 商品小类型 选填
	 * @param belongareacode 区域编码  选填
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年6月16日 下午1:59:45
	 */
	@SuppressWarnings("rawtypes")
	public PageInfo<ProductAreaPriceVo> findStores(PageInfo pageInfo, String productNo,String productName,Integer level,BigDecimal minPrice,BigDecimal maxPrice,String bigType,String subType,String ...belongareacode);
	
	/**
	 * 根据门店编号获取区域编码
	 * @Title: findBySalesAreaCodeByStoreNo 
	 * @param storeNo 门店编码
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年6月16日 下午9:08:08
	 */
	public String findBySalesAreaCodeByStoreNo(String storeNo);
}
