package com.biz.interfacedocker.wallet.rebate.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 描述:
 * 电子钱包已返利商品
 *
 * @author Vincent
 * @create 2017-11-29 15:43
 * @project_name interfaceDocker
 */
public class WalletRebateProductDTO implements Serializable{
	private static final long serialVersionUID = -3818563995023312674L;

	/**
	 * 商品编码
	 */
	private String productCode;

	/**
	 * 商品名称
	 */
	private String productName;

	/**
	 * 商品返利数量
	 */
	private int rebateQuantity;

	/**
	 * 单个商品返利金额
	 */
	private int productRebateAmount;

	/**
	 * 商品返利总额（数量 * 返利金额）
	 */
	private int productRebateTotalAmount;

	public String getProductCode() {
		return productCode;
	}

	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public int getRebateQuantity() {
		return rebateQuantity;
	}

	public void setRebateQuantity(int rebateQuantity) {
		this.rebateQuantity = rebateQuantity;
	}

	public int getProductRebateAmount() {
		return productRebateAmount;
	}

	public void setProductRebateAmount(int productRebateAmount) {
		this.productRebateAmount = productRebateAmount;
	}

	public int getProductRebateTotalAmount() {
		return productRebateTotalAmount;
	}

	public void setProductRebateTotalAmount(int productRebateTotalAmount) {
		this.productRebateTotalAmount = productRebateTotalAmount;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
