package com.biz.interfacedocker.winecard.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 电子储值卡订单返利详情DTO
 *
 * @author Zebe
 */
public class WineCardRebateOrderDTO implements Serializable {

    private static final long serialVersionUID = 5437442776080666191L;

    /**
     * 订单编码
     */
    private String orderNo;

    /**
     * 返利总金额
     */
    private BigDecimal rebateTotalAmount;

    /**
     * 0=处理失败 1=无需处理(未存在返利) 2=已经处理返利
     */
    private Integer status;

    /**
     * 消息  处理失败 无需处理(未存在返利) 已经处理返利
     */
    private String message;

    /**
     * 返利时间（充值到账户的时间）
     */
    private Date rebateTime;

    /**
     * 系统当前时间
     */
    private Date currentTime;

    /**
     * 返利商品明细
     */
    private List<WineCardRebateProductDTO> wineCardRebateProductDTOS;


    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public BigDecimal getRebateTotalAmount() {
        return rebateTotalAmount;
    }

    public void setRebateTotalAmount(BigDecimal rebateTotalAmount) {
        this.rebateTotalAmount = rebateTotalAmount;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getRebateTime() {
        return rebateTime;
    }

    public void setRebateTime(Date rebateTime) {
        this.rebateTime = rebateTime;
    }

    public Date getCurrentTime() {
        return currentTime;
    }

    public void setCurrentTime(Date currentTime) {
        this.currentTime = currentTime;
    }

    public List<WineCardRebateProductDTO> getWineCardRebateProductDTOS() {
        return wineCardRebateProductDTOS;
    }

    public void setWineCardRebateProductDTOS(List<WineCardRebateProductDTO> wineCardRebateProductDTOS) {
        this.wineCardRebateProductDTOS = wineCardRebateProductDTOS;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
