package com.biz.interfacedocker.winecard.dto;

import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 电子储值卡商品返利详情DTO
 *
 * @author Zebe
 */
public class WineCardRebateProductDTO implements Serializable {

    private static final long serialVersionUID = -3818563995023312674L;

    /**
     * 商品编码
     */
    private String productCode;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 返利商品数量
     */
    private int rebateQuantity;

    /**
     * 单个商品返利金额
     */
    private BigDecimal productRebateAmount;

    /**
     * 商品返利总额（数量 * 返利金额）
     */
    private BigDecimal productRebateTotalAmount;

    public String getProductCode() {
        return productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public int getRebateQuantity() {
        return rebateQuantity;
    }

    public void setRebateQuantity(int rebateQuantity) {
        this.rebateQuantity = rebateQuantity;
    }

    public BigDecimal getProductRebateAmount() {
        return productRebateAmount;
    }

    public void setProductRebateAmount(BigDecimal productRebateAmount) {
        this.productRebateAmount = productRebateAmount;
    }

    public BigDecimal getProductRebateTotalAmount() {
        return productRebateTotalAmount;
    }

    public void setProductRebateTotalAmount(BigDecimal productRebateTotalAmount) {
        this.productRebateTotalAmount = productRebateTotalAmount;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
