package com.biz.interfacedocker.callcenter.order.service;


import com.biz.interfacedocker.callcenter.order.vo.memberorder.OrderBaseRespVo;

import java.util.List;
import java.util.Map;


/**
 * 
 * @Description: Call Center订单服务接口
 * @ClassName: com.biz.interfacedocker.callcenter.service.OrderService
 * @author: david-liu
 * @date: Jun 15, 2016 11:24:46 AM
 *
 */
public interface CallCenterOrderApiService {
    /**
     * 
     * @Title: findOrderDetail 订单明细查询
     * @param searchParam
     * @return
     * @author: david-liu
     * @date: Jun 15, 2016 11:25:42 AM
     */
    List<Map<String, Object>> findOrderDetail(Map<String, Object> searchParam);
    
    /**
     * 
     * @Title: findOrderMainInfo 订单主数据查询
     * @param searchParam
     * @return
     * @author: david-liu
     * @date: Jun 16, 2016 10:25:03 AM
     */
    List<Map<String, Object>> findOrderMainInfo(Map<String, Object> searchParam);
    /**
     *
     * @Title: findOrderMainInfo 订单所有数据查询
     * @param list
     * @return
     * @author: Jay_tao
     */
    List<Map<String, Object>> findOrderAllInfoPage(List list);
    
    List<Map<String, Object>> findOrderMainInfoPage(Map<String, Object> searchParam);
    
    List<Map<String, Object>> findOrderOldMainInfoPage(Map<String, Object> searchParam);
    
    /**
     * 
     * @Title: findOrderDelivery 订单配送信息查询
     * @param searchParam
     * @return
     * @author: david-liu
     * @date: Jun 17, 2016 1:32:29 PM
     */
    List<Map<String, Object>> findOrderDelivery(Map<String, Object> searchParam);
    
    /**
     * @Title: findHistoryOrderInvoice 订单发票信息历史数据
     * @author: JOE-liu
     */
    List<Map<String,Object>> findHistoryOrderInvoice(Map<String, Object> searchParam);
    

    /**
     * @Title: findHistoryOrderInvoice 订单发票信息数据
     * @author: JOE-liu
     */
    List<Map<String,Object>> findOrderInvoice(Map<String, Object> searchParam);

	long omsTotalReored(Map<String, Object> searchParam);

	long totalReored(Map<String, Object> searchParam);

    /**
     * 根据会员电话查询最近一个月内订单主信息
     *
     * @param membersPhone 会员电话
     * @return 最近一个月内订单主信息
     */
    List<OrderBaseRespVo> findOrderBaseByMembersPhone(String membersPhone);
     
}
