package com.biz.interfacedocker.common.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.biz.interfacedocker.callcenter.order.vo.OrderMainInfoRespVo;
import com.biz.interfacedocker.common.JsonResult;
import com.biz.interfacedocker.common.type.HttpResultStatus;

/**
 * 
 * @Description: Call Center 构造返回JsonResult对象工具
 * @ClassName: com.biz.centerdocker.common.util.ServiceUtil
 * @author: david-liu
 * @date: Jun 14, 2016 3:36:22 PM
 *
 */
public class ServiceUtil {

	/**
	 * 
	 * @Title: returnSuccess 根据泛型对象返回共通成功对象
	 * @param t 泛型对象
	 * @return
	 * @author: david-liu
	 * @date: Jun 14, 2016 3:37:01 PM
	 */
	public static <T> JsonResult<T> returnSuccess(T t){
		return new JsonResult<T>(HttpResultStatus.EXECUTE_SUCCESS, t);
	}
	
	/**
	 * 
	 * @Title: returnParamError 返回共通参数错误返回对象
	 * @param code_msg 错误信息
	 * @return
	 * @author: david-liu
	 * @date: Jun 14, 2016 3:37:33 PM
	 */
	public static <T> JsonResult<T> returnParamError(String code_msg){
		JsonResult<T> jsonResult = new JsonResult<T>(HttpResultStatus.PARAMETER_ERROR, code_msg);
		return jsonResult;
	}
	/**
	 * 
	 * @Title: returnParamError 返回共通参数错误返回对象
	 * @param code_msg 错误信息
	 * @return
	 * @author: david-liu
	 * @date: Jun 14, 2016 3:37:33 PM
	 */
	public static <T> JsonResult<T> returnSystemError(String code_msg){
		JsonResult<T> jsonResult = new JsonResult<T>(HttpResultStatus.SYSTEM_ERROR, code_msg);
		return jsonResult;
	}
	
	/**
	 * 
	 * @Title: returnParamError 返回自定义错误返回对象
	 * @param code_msg 错误信息
	 * @return
	 * @author: david-liu
	 * @date: Jun 14, 2016 3:37:33 PM
	 */
	public static <T> JsonResult<T> returnError(HttpResultStatus status,String code_msg){
		JsonResult<T> jsonResult = new JsonResult<T>(status, code_msg);
		return jsonResult;
	}
	/**
	 * 
	 * @Title: returnSuccessWithPage 返回带分页信息的成功结果对象
	 * @param t 泛型对象
	 * @param page 当前页
	 * @param pageSize 页大小
	 * @return
	 * @author: david-liu
	 * @date: Jun 14, 2016 3:38:18 PM
	 */
	public static <T> JsonResult<Map<String, Object>> returnSuccessWithPage(T t, int page, int pageSize) {
		Map<String, Object> respWithPage = new HashMap<String, Object>();
		respWithPage.put("page", page);
		respWithPage.put("pageSize", pageSize);
		respWithPage.put("data", t);
		return new JsonResult<Map<String, Object>>(HttpResultStatus.EXECUTE_SUCCESS, respWithPage);
	}
	
	/**
	 * 
	 * @Title: returnSuccessWithPage 返回带分页信息的成功结果对象
	 * @param t 泛型对象
	 * @param page 当前页
	 * @param pageSize 页大小
	 * @param subMsg 提示语
	 * @return
	 */
	public static <T> JsonResult<Map<String, Object>> returnSuccessWithOrderPage(T t, int page, int pageSize,String subMsg) {
		Map<String, Object> respWithPage = new HashMap<String, Object>();
		respWithPage.put("page", page);
		respWithPage.put("pageSize", pageSize);
		respWithPage.put("data", t);
		return new JsonResult<Map<String, Object>>(HttpResultStatus.EXECUTE_SUCCESS, subMsg,respWithPage);
	}
	/**
	 * 
	 * @Title: returnSuccessWithPage 返回带分页信息的成功结果对象
	 * @param t 泛型对象
	 * @param page 当前页
	 * @param pageSize 页大小
	 * @param count 总条数
	 * @param totalPage 总页数
	 * @param subMsg 提示语
	 * @return
	 */
	public static  <T>JsonResult<Map<String, Object>> returnSuccessWithJdePage(T t, int page, int pageSize, Integer jdePageNo,long count, long totalPage) {
		Map<String, Object> respWithPage = new HashMap<String, Object>();
		respWithPage.put("page", page);
		respWithPage.put("pageSize", pageSize);
		respWithPage.put("data", t);
		respWithPage.put("jdePageNo", jdePageNo);
		respWithPage.put("count", count);
		respWithPage.put("totalPage", totalPage);
		return new JsonResult<Map<String, Object>>(HttpResultStatus.EXECUTE_SUCCESS, respWithPage);
	}

	public static <T> JsonResult<Map<String, Object>> returnSuccessWithPage(T t, int page, int pageSize, long count, long totalPage) {
		Map<String, Object> respWithPage = new HashMap<String, Object>();
		respWithPage.put("page", page);
		respWithPage.put("pageSize", pageSize);
		respWithPage.put("data", t);
		respWithPage.put("count", count);//count 总条数
		respWithPage.put("totalPage", totalPage);//totalPage 总页数
		return new JsonResult<Map<String, Object>>(HttpResultStatus.EXECUTE_SUCCESS, respWithPage);
	}

	 
	
}
