/**
 * @Description: 
 * @ClassName: com.biz.dbDocker.service.InventoryDbService
 * @author: Omar(OmarZhang)
 * @date: 2016年3月7日 上午10:47:16 
 */
package com.biz.interfacedocker.dbdocker.service;

import java.util.List;

import com.biz.interfacedocker.common.JsonResult;
import com.biz.interfacedocker.dbdocker.vo.StockBatchVo;
import com.biz.interfacedocker.dbdocker.vo.StockVo;

/**
 * 库存接口
 * @Description: 
 * @ClassName: com.biz.dbDocker.service.InventoryDbService
 * @author: Omar(OmarZhang)
 * @date: 2016年3月7日 上午10:47:16 
 *
 */
public interface InventoryDbApiService {
	
	/**
	 * 根据商品长编码和门店编号 获取商品库存
	 * @Title: findInventoryByProductLongNumber 
	 * @param storeNum 门店编码 
	 * @param longNum[]  商品长编码
	 * @return List<InventoryDbVo> / null
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月7日 上午11:11:42
	 */
	public JsonResult<List<StockVo>> findInventoryByProductLongNumAndStoreNum(String storeNum,String ... longNum);
	

	/**
	 * 查询某个商品在某个门店的库存
	 * @param mcuCode 门店编码
	 * @param productCode 商品编码
	 * @return  
	 */
	public JsonResult<StockVo> findByMcuCodeAndProductCode(String mcuCode ,String productCode);
 	/**
	 * 库存变化调用接口
	 * @param mcuCode
	 * @param productCode
	 * @param changeStock
	 * @param unit
	 * @param bill
	 * @param type
	 * @return
	 */
	public JsonResult<StockVo> changeStock(String mcuCode, String productCode,Long changeStock,String unit,String bill,String type,String orderNo,String orderSource,Long changeTime);
	/**
	 * 批量更新库存
	 * @param list
	 * @return
	 */
	public JsonResult<List<StockVo>> changeBatchStock(List<StockBatchVo> list);
	
	/**
	 * 根据省仓编码和商品编码查询库存
	 * @param provinceNum
	 * @param longNum
	 * @return
	 */
	public JsonResult<List<StockVo>> findInventoryByProductLongNumAndProvinceNum(String provinceNum,String ... longNum);


}
