/**
 * 
 */
package com.biz.interfacedocker.dbdocker.service;

import java.util.List;

import com.biz.interfacedocker.common.JsonResult;
import com.biz.interfacedocker.dbdocker.vo.StockBatchLockVo;
import com.biz.interfacedocker.dbdocker.vo.StockLockEnum;

/**
 * @author yangshuo
 * 预先锁定库存
 *
 */
public interface StockLockService {
	/**
	 * 查询库存数量是否符合条件
	 * @param list
	 * @return
	 */
	public  JsonResult<Boolean> checkStock(List<StockBatchLockVo> list);
	
	/**
	 * 锁定或者解除锁定
	 * @param list
	 * @param stockLock 操作类型 枚举
	 * @return
	 */
	public  JsonResult<Boolean> changeStock(List<StockBatchLockVo> list,StockLockEnum stockLock);
	
	/**
	 * 锁定库存 返回是否成功
	 * @param list
	 * @return
	 */
//	public  JsonResult<Boolean> lockStock(List<StockBatchLockVo> list);
	
	/**
	 * 释放锁定的库存 返回是否成功
	 * @param list
	 * @return
	 */
//	public  JsonResult<Boolean> releaseStock(List<StockBatchLockVo> list);
	
	/**
	 * 门店改派 返回是否成功
	 * @param list
	 * @return
	 */
//	public  JsonResult<Boolean> changeMcuStock(List<StockBatchLockVo> list);

}
