/**
 * @Description: 
 * @ClassName: com.biz.commondocker.dbdocker.StoreApiSerivce
 * @author: Omar(OmarZhang)
 * @date: 2016年2月29日 下午8:19:37 
 */
package com.biz.interfacedocker.dbdocker.service;

import java.util.List;
import java.util.Map;

import com.biz.interfacedocker.common.page.PageInfo;
import com.biz.interfacedocker.dbdocker.vo.StoreDbVo;

/**
 * 门店服务接口
 * @Description: 
 * @ClassName: com.biz.commondocker.dbdocker.StoreApiSerivce
 * @author: Omar(OmarZhang)
 * @date: 2016年2月29日 下午8:19:37 
 *
 */
public interface StoreDbApiService {
	
	/***
	 * 根据经纬度查询附近的门店
	 * 默认距离从近到远
	 * @Title: findStoresByLngALat 
	 * @param lat 经度
	 * @param lng 纬度
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年2月29日 下午8:28:54
	 */
	public List<StoreDbVo> findNearStoresByLngAndLat(String lat,String lng);
	
	/**
	 * 根据经纬度以及是门店是否可开票查询
	 * 返回附近门店.
	 * @Title: findNearStoresByLatAndLng 
	 * @param lat 经度
	 * @param lng 纬度
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param isCanTicket 是否可开票
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月1日 下午9:45:39
	 */
	public List<StoreDbVo> findNearStoresByLatAndLng(String lat, String lng, String provinceName, String cityName,String provinceCode, String cityCode,Boolean isCanTicket);
	
	/**
	 * 根据经纬度以及是门店是否可开票查询
	 * 返回附近门店.
	 * @Title: findNearStoresByLatAndLng 
	 * @param lat 经度
	 * @param lng 纬度
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param searchDistance 搜索距离 单位为km
	 * @param isCanTicket 是否可开票
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月1日 下午9:45:39
	 */
	public List<StoreDbVo> findNearStoresByLatAndLng(String lat, String lng, String provinceName, String cityName,String provinceCode, String cityCode,Double searchDistance,Boolean isCanTicket);
	
	/**
	 * 根据经纬度以及是门店是否可开票查询
	 * 返回附近门店.
	 * @Title: findNearStoresByLatAndLng 
	 * @param lat 经度
	 * @param lng 纬度
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param searchDistance 搜索距离 单位为km
	 * @param filterParamers 过滤参数
	 * @param isCanTicket 是否可开票
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月1日 下午9:45:39
	 */
	public List<StoreDbVo> findNearStoresByLatAndLng(String lat, String lng, String provinceName, String cityName,String provinceCode, String cityCode,Double searchDistance,Map<String,String> filterParamers, Boolean isCanTicket);
	
	
	/**
	 * 根据经纬度以及是门店是否可开票查询
	 * 返回附近门店.
	 * @Title: findNearStoresByLatAndLng 
	 * @param lat 经度
	 * @param lng 纬度
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param searchDistance 搜索距离 单位为km
	 * @param isProvience 是否省会
	 * @param filterParamers 过滤参数
	 * @param isCanTicket 是否可开票
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月1日 下午9:45:39
	 */
	public List<StoreDbVo> findNearStoresByLatAndLng(String lat, String lng, String provinceName, String cityName,String provinceCode, String cityCode,Double searchDistance,Boolean isProvience,Map<String,String> filterParamers, Boolean isCanTicket);
	
	/**
	 * 根据经纬度以及是门店是否可开票查询
	 * 返回附近门店.
	 * @Title: findNearStoresByLatAndLng 
	 * @param lat 经度
	 * @param lng 纬度
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param searchDistance 搜索距离 单位为km
	 * @param isProvience 是否省会
	 * @param filterParamers 过滤参数
	 * @param isCanTicket 是否可开票
	 * @param isProvincialWarehouse 是否省仓
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月1日 下午9:45:39
	 */
	public List<StoreDbVo> findNearStoresByLatAndLng(String lat, String lng, String provinceName, String cityName,String provinceCode, String cityCode,Double searchDistance,Boolean isProvience,Map<String,String> filterParamers, Boolean isCanTicket,Boolean isProvincialWarehouse);
	
	/**
	 * 根据经纬度以及是门店是否可开票查询
	 * 返回附近门店.
	 * @Title: findNearStoresByLatAndLng 
	 * @param lat 经度
	 * @param lng 纬度
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param searchDistance 搜索距离 单位为km
	 * @param isProvience 是否省会
	 * @param filterParamers 过滤参数
	 * @param isCanTicket 是否可开票
	 * @param isProvincialWarehouse 是否省仓
	 * @param storeType 门店类型  dd: 店中店 ps: 配送电 qj: 旗舰店 qy: 区域店 zx: 中心店
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月1日 下午9:45:39
	 */
	public List<StoreDbVo> findNearStoresByLatAndLng(String lat, String lng, String provinceName, String cityName,String provinceCode, String cityCode,Double searchDistance,Boolean isProvience,Map<String,String> filterParamers, Boolean isCanTicket,Boolean isProvincialWarehouse,String storeType);
	
	/**
	 * 根据经纬度以及是门店是否可开票查询
	 * 返回附近门店.
	 * @Title: findNearStoresByLatAndLng 
	 * @param lat 经度
	 * @param lng 纬度
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param searchDistance 搜索距离 单位为km
	 * @param isProvience 是否省会
	 * @param filterParamers 过滤参数
	 * @param isCanTicket 是否可开票
	 * @param isProvincialWarehouse 是否省仓
	 * @param isCenterStore 是否中心门店,该选型只适合双11
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月1日 下午9:45:39
	 */
	public List<StoreDbVo> findNearStoresByLatAndLng(String lat, String lng, String provinceName, String cityName,String provinceCode, String cityCode,Double searchDistance,Boolean isProvience,Map<String,String> filterParamers, Boolean isCanTicket,Boolean isProvincialWarehouse,Boolean isCenterStore);
	
	/***
	 * 根据本店编号(集合)获取门店(集合)
	 * @Title: findStoreByStoreNo 
	 * @param storeNos 门店编号集合
	 * @return List<StoreDbVo>
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月10日 下午7:59:21
	 */
	public List<StoreDbVo> findStoreByStoreNos(String... storeNos);
	
	/**
	 * 根据门店编号返回门店信息
	 * @Title: findStoreByStoreNo 
	 * @param storeNo 门店编号
	 * @return StoreDbVo
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月10日 下午7:59:51
	 */
	public StoreDbVo findStoreByStoreNo(String storeNo);
	
	/**
	 * 根据 省,市,区 名称查询门店数据信息
	 * @Title: findByProvinceCityDistrict 
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param districtName 区名称
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年6月16日 上午1:25:37
	 */
	public List<StoreDbVo> findByProvinceCityDistrictName(String provinceName,String cityName,String districtName);
	
	/**
	 * 根据 省,市,区 编码查询门店数据信息
	 * @Title: findByProvinceCityDistrictCode 
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param districtCode 区编码
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年6月16日 上午1:26:45
	 */
	public List<StoreDbVo> findByProvinceCityDistrictCode(String provinceCode,String cityCode,String districtCode);
	
	/**
	 * 获取门店信息 分页
	 * @Title: findStores 
	 * @param pageInfo 分页信息
	 * @param queryCondition 查询信息
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月9日 下午6:01:25
	 */
	@SuppressWarnings("rawtypes")
	public PageInfo<StoreDbVo> findStores(PageInfo pageInfo, Map<String,String> queryCondition);

	/**
	 * 根据原JDE门店编号获取现目前的门店编号
	 * @Title: findByJDEStoreNo 
	 * @param storeNo 原JDE门店编号
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年7月23日 下午10:18:03
	 */
	public StoreDbVo findByJDEStoreNo(String storeNo);

	/**
	 * @Title: findNearStoresByLatAndLng 
	 * @param lat 经度
	 * @param lng 纬度
	 * @param provinceName 省名称
	 * @param cityName 市名称
	 * @param provinceCode 省编码
	 * @param cityCode 市编码
	 * @param searchDistance 搜索距离 单位为km
	 * @param isProvience 是否省会
	 * @param filterParamers 过滤参数
	 * @param queryParamers 查询参数
	 * @param isCanTicket 是否可开票
	 * @param isProvincialWarehouse 是否省仓
	 * @param storeType 门店类型  dd: 店中店 ps: 配送电 qj: 旗舰店 qy: 区域店 zx: 中心店
	 * @return
	 * @author: TRivers.chen(Administrator)
	 * @date: 2016年12月11日 下午3:21:53
	 */
	List<StoreDbVo> findNearStoresByLatAndLng(String lat, String lng, String provinceName, String cityName,
			String provinceCode, String cityCode, Double searchDistance, Boolean isProvience,
			Map<String, String> filterParamers, Map<String, String> queryParamers, Boolean isCanTicket,
			Boolean isProvincialWarehouse, String storeType);
	
	
}
