package com.biz.interfacedocker.mdbWeb.service;

import java.util.List;

import com.biz.interfacedocker.mdbWeb.vo.SmdWebVo;
import com.biz.interfacedocker.mdbWeb.vo.common.Pager;
public interface SmdWebApiService {

	/**
	 * 返回所有门店信息
	 * 
	 * @return
	 */
	public List<SmdWebVo> findAll();

	/**
	 * 根据查询条件分页返回门店主数据
	 * 
	 * @Title: findSmdByParams
	 * @param WERKS
	 *            门店编码
	 * @param JDE_WERKS
	 *            JDE对应门店编码
	 * @param NAME1
	 *            门店名称
	 * @param REGION
	 *            省编码
	 * @param CITYC
	 *            市编码
	 * @param LZONE
	 *            区/县编码
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public Pager<SmdWebVo> findSmdByParams(String WERKS, String JDE_WERKS,String NAME1, String REGION,
			String CITYC, String LZONE, Integer pageNum, Integer pageSize);

	/**
	 * 查询门店信息 主要查询区域
	 * 
	 * @param regionCode
	 *            省编号
	 * @param citycCode
	 *            市编码
	 * @param lzoneCode
	 *            区/县编码
	 * */
	public List<SmdWebVo> findZclass(String regionCode, String citycCode,
			String lzoneCode);
	
	/**
	 * 根据省公司查询省公司下的所有门店
	 * 
	 * @Title: findAllSmdByProvinceCompanyPage
	 * @param provinceCompanyId
	 *            省公司编码
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年8月26日 上午10:29:36
	 */
	public Pager<SmdWebVo> findAllSmdByProvinceCompanyPage(String provinceCompanyId,Integer pageNum, Integer pageSize);
	
	/**
	 * 根据更新时间查询门店
	 * 
	 * @param updatetimeLt
	 *            开始时间
     * @param updatetimeGt
	 *            结束时间
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年09月29日 上午10:29:36
	 */
	public List<SmdWebVo> findSmdByUpdatetime(String updatetimeLt,String updatetimeGt);

}
