package com.biz.interfacedocker.mdbWeb.service;

import java.math.BigDecimal;
import java.util.List;
import com.biz.interfacedocker.mdbWeb.vo.PromotionPriceWebVo;
import com.biz.interfacedocker.mdbWeb.vo.VipPriceWebVo;
import com.biz.interfacedocker.mdbWeb.vo.common.Pager;


/**
 * Created by zhouyannian on 2016/7/7.
 */
public interface VipPriceWebApiService {

	/**
	 * 返回所有价格信息
	 * 
	 * @return
	 */
    public List<VipPriceWebVo> findAll();

	/**
	 * 根据查询条件分页返回价格主数据信息
	 * 
	 * @Title: findVipPriceByParams
	 * @param MATNR
	 *            商品编码
	 * @param MAKTX
	 *            商品描述
	 * @param AREA
	 *            区域
	 * @param level
	 *            会员等级
	 * @param minPrice
	 *            最低零售价
	 * @param maxPrice
	 *            最高零售价
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public Pager<VipPriceWebVo> findVipPriceByParams(String MATNR,
			String MAKTX, String AREA, Integer level, BigDecimal minPrice,
			BigDecimal maxPrice, Integer pageNum, Integer pageSize);
	
	/**
	 * 根据查询条件分页返回价格主数据和部分商品主数据信息
	 * 
	 * @Title: findPriceAndCpmd
	 * @param MATNR
	 *            商品编码
	 * @param MAKTX
	 *            商品描述
	 * @param AREA
	 *            区域
	 * @param level
	 *            会员等级
	 * @param minPrice
	 *            最低零售价
	 * @param maxPrice
	 *            最高零售价
	 * @param BigClass
	 *            商品大类
	 * @param pageNum
	 *            显示第几页
	 * @param pageSize
	 *            每页显示条数
	 * @return
	 * @author: zhouyannian
	 * @date: 2016年7月21日 上午10:29:36
	 */
	public Pager<VipPriceWebVo> findPriceAndCpmd(String MATNR,
			String MAKTX, String AREA, Integer level, BigDecimal minPrice,
			BigDecimal maxPrice, String BigClass,Integer pageNum, Integer pageSize);
	
	/**
	 * 根据商品编码返回促销价格
	 * 
	 * @Title: findPromotionPriceByGoodsId
	 * @param goodsId
	 *            商品编码
	 * @param request
	 * @return
	 * @author: zhouyannian
	 * @date: 2017年1月21日 上午10:29:36
	 */
	public List<PromotionPriceWebVo> findPromotionPriceByGoodsId(String goodsId);
}
