/**
 * 
 */
package com.biz.interfacedocker.memberdocker.service;

import java.math.BigDecimal;
import java.util.List;

import com.biz.interfacedocker.callcenter.member.vo.MemberInfoInVo;
import com.biz.interfacedocker.callcenter.member.vo.MemberMultiPhoneInfoVo;
import com.biz.interfacedocker.common.JsonResult;
import com.biz.interfacedocker.memberdocker.vo.BankVo;
import com.biz.interfacedocker.memberdocker.vo.CreditVo;
import com.biz.interfacedocker.memberdocker.vo.MemberAddressVo;
import com.biz.interfacedocker.memberdocker.vo.MemberInfoPosVo;
import com.biz.interfacedocker.memberdocker.vo.MemberInfoVo;
import com.biz.interfacedocker.memberdocker.vo.MemberLevelVo;
import com.biz.interfacedocker.memberdocker.vo.MemberPointVo;

/**
 * @author yangshuo
 * ucenter集成进来
 *
 */
public interface MemberInfoApiService {
 
	/**
	 * 查询渠道是否存在
	 * @param channelCode
	 * @return
	 */
	public JsonResult<Boolean> queryChannelByCode( String channelCode);
	/**
	 * 查询个人信息
	 * @param memberinfo
	 * @return
	 */
	public JsonResult<MemberInfoVo> select( String name,String channelCode);

	
	/**
	 * 新增会员
	 * @param memberinfo
	 * @return
	 * @throws AxisFault 
	 */
	public JsonResult<Long>  createMemberInfo( MemberInfoVo memberinfo) throws Exception;
	/**
	 * 修改会员信息
	 * @param memberinfo
	 * @return
	 */
	public JsonResult<Boolean> modidyMemberInfo( MemberInfoVo memberinfo);
	/**
	 * 会员修改密码
	 * @param userName
	 * @param oldPassword
	 * @param newPassword
	 * @return
	 */
	public JsonResult<Boolean> changeMemberPassword(Long memberId,String oldPassword,String oldOriginalpwd,String newPassword,String channelCode,String originalpwd);
	
	/**
	 * 重置密码
	 * @param userName
	 * @param newPassword
	 * @return
	 */
	public JsonResult<Boolean> resetMemberPassword(Long memberId,String password,String originalpwd,String channelCode);
	
	
	/**
	 * 新增收货地址
	 * @param memberAddress
	 * @return
	 */
	public JsonResult<Long> createMemberAddress(MemberAddressVo memberAddress);
	
	/**
	 * 修改收货地址
	 * @param memberAddress
	 * @return
	 */
	public JsonResult<Boolean> modifyMemberAddress(MemberAddressVo memberAddress);
	
	/**
	 * 删除收货地址
	 * @param addressId
	 * @return
	 */
	public JsonResult<Boolean>  deleteMemberAddress( Long addressId,Long memberId);
	/**
	 * 查询会员收货地址
	 * @param channelCode
	 * @param memberId
	 * @return
	 */
	public JsonResult<List<MemberAddressVo>> selectMemberAddress( String channelCode,Long memberId);
	
	/**
	 * 会员登录
	 * @param name
	 * @param password
	 * @param originalpwd
	 * @param channelCode
	 * @return
	 */
	public  JsonResult<MemberInfoVo> login(String name, String password, String originalpwd, String channelCode);
	
	/**
	 * 根据id查询会员信息
	 * @param memberId
	 * @param channelCode
	 * @return
	 */
	public JsonResult<MemberInfoVo> selectMemberById( Long memberId,String channelCode);
	
	/**
	 * 查询会员默认收货地址
	 * @param channelCode
	 * @param memberId
	 * @return
	 */
	public  JsonResult<List<MemberAddressVo>> selectMemberDefaultAddress(String channelCode,Long memberId);
	
	/**
	 * 根据收货地址id查询会员收货地址
	 * @param addrId
	 * @return
	 */
	public  JsonResult<MemberAddressVo> selectMemberAddressById(Long addrId);
	
	/**
	 * 设置会员默认收货地址
	 * @param addrId
	 * @return
	 */
	public  JsonResult<MemberAddressVo> setMemberDefaultAddress(Long addrId);
	
	/**
	 * 为会员添加银行卡
	 * @param bank
	 * @return
	 */
	public JsonResult<Long>  createMemberBank( BankVo bank);
	
	/**
	 * 查询会员绑定的银行卡
	 * @param memberId
	 * @return
	 */
	public JsonResult<List<BankVo>>  selectMemberBank( Long memberId);
	
	/**
	 * 更新会员银行卡
	 * @param bank
	 * @return
	 */
	public JsonResult<Long>  updateMemberBank( BankVo bank);
	
	/**
	 * 删除银行卡
	 * @param id 银行卡的id
	 * @return
	 */
	public JsonResult<Boolean>  deleteMemberBank( Long id);
	
	
	/**
	 * 设置默认银行卡
	 * @param id 银行卡的id
	 * @return
	 */
	public JsonResult<Long>  setDefaultMemberBank(Long id);
	
	/**
	 * 直接查询会员信用额度
	 * @param name
	 * @return
	 */
	public JsonResult<List<CreditVo>>  selectMemberCredit(String name,String memberType);
	/**
	 * 变更会员信用额度
	 * @param name 会员名
	 * @param memberType 会员类型
	 * @param credited 要加减的已用信用额度值，‘-’表示减
	 * @return
	 */
	public JsonResult<BigDecimal>  editMemberCredit(String name,String memberType,BigDecimal credited);
	/**
	 * 直接查询会员预存款
	 * @param name
	 * @param memberType
	 * @return
	 */
	public JsonResult<BigDecimal>  selectMemberMoney(String name,String memberType);
	/**
	 * 预存款更改
	 * @param name 会员名
	 * @param memberType 会员类型
	 * @param money  要加减的预存款值，‘-’表示减
	 * @return 
	 */
	public JsonResult<BigDecimal>  editMemberMoney(String name,String memberType,BigDecimal money);
	/**
	 * crm调用通知
	 * @param type
	 * @return
	 */
	public JsonResult<Boolean> notify(String type);
	/**
	 * 会员实时修改等级积分通知
	 * @param type
	 * @param uname
	 * @param data
	 * @return
	 */
	public JsonResult<Boolean>  notifyCurrent(String type,String uname,Integer data);
	/**
	 * 根据会员多电话查询会员信息
	 * @param phone
	 * @param channelCode
	 * @return
	 */
	public JsonResult<MemberInfoVo> selectMemberByMultiPhone( String phone,String channelCode);
	/**
	 * crm调用通知 当会员的多电话 变化的时候被调用
	 * @param phone
	 * @return
	 */
	public JsonResult<Boolean> notifyMultiPhone(String phone);
	
	/**
	 * 查询会员等级
	 * @param memberId
	 * @param channelCode
	 * @return
	 */
	public JsonResult<MemberLevelVo>  findMemberLevel(Long memberId,String channelCode);
	
	/**
	 * 查询会员积分
	 * @param memberId
	 * @param channelCode
	 * @return
	 */
	public JsonResult<MemberPointVo>  findMemberPoint(Long memberId,String channelCode);
	
	/**
	 * 查询会员锁定状态
	 * @param memberId
	 * @return
	 */
	public JsonResult<Integer>  selectMemberState(Long memberId, String channelCode);
	
	/**
	 * 查询会员锁定状态
	 * @param userName 登录名 手机 email
	 * @param channelCode
	 * @return
	 */
	public JsonResult<Integer>  selectMemberStateByName(String userName, String channelCode);
	
	/**
	 * 修改会员锁定状态接口
	 * @param uname
	 * @param mobile
	 * @param state
	 * @param password
	 * @param channelCode
	 * @return
	 */
	public JsonResult<Integer>  editMemberState(String uname, String mobile,Integer state,String password,String channelCode);
	
	/**
	 * 当crm修改会员锁定状态的时候调用
	 * @param uname
	 * @return
	 */
	public JsonResult<Boolean>  notifyMemberState(String uname);

	/**
	 * CC接口 查询会员多电话
	 * @param vo
	 * @return
	 */
	public JsonResult<List<MemberMultiPhoneInfoVo>> findMemberMultiPhone(MemberInfoInVo vo);
	/**
	 * 查询会员信息 POS专用
	 * @param name
	 * @return
	 */
	public JsonResult<MemberInfoVo> selectPos( String name);
	/**
	 * pos查询会员信息 附带查询出来会员信用额度和预存款
	 * @param name
	 * @return
	 */
	public JsonResult<MemberInfoPosVo> selectPosSuper(String name);
	
	/**
	 * 根据会员id 查询会员信息 POS专用
	 * @param memberId
	 * @return
	 */
	public JsonResult<MemberInfoVo> selectMemberByIdPos(Long memberId);
	
	/**
	 * 直接查询会员信用额度  pos
	 * @param name
	 * @return
	 */
	public JsonResult<List<CreditVo>>  selectMemberCreditPos(String name);
	/**
	 * 变更会员信用额度
	 * @param name 会员名
	 * @param memberType 会员类型
	 * @param credited 要加减的已用信用额度值，‘-’表示减
	 * @return
	 */
	public JsonResult<BigDecimal>  editMemberCreditPos(String name,BigDecimal credited,String empId,String empName,String mcuCode,String mcuName);
	/**
	 * 直接查询会员预存款
	 * @param name
	 * @param memberType
	 * @return
	 */
	public JsonResult<BigDecimal>  selectMemberMoneyPos(String name);
	/**
	 * 预存款更改
	 * @param name 会员名
	 * @param memberType 会员类型
	 * @param money  要加减的预存款值，‘-’表示减
	 * @return 
	 */
	public JsonResult<BigDecimal>  editMemberMoneyPos(String name,BigDecimal money,String empId,String empName,String mcuCode,String mcuName);
	/**
	 * 为会员重新设置手机号或者email
	 * @param memberId
	 * @param oldAccount
	 * @param newAccount
	 * @return
	 */
	public JsonResult<Boolean> changeLoginAccount(Long memberId,String oldAccount,String newAccount,String loginType,String ownerQuene);

	
	/**
	 * 当会员密码在管理平台被修改之后通知阿里云
	 * @param memberId
	 */
	public void notifyALiyun(Long memberId);
}
