package com.biz.interfacedocker.memberdocker.vo;

import com.biz.interfacedocker.memberdocker.enums.APIStatus;

/**
 * WebService接口执行结果基类，所有结果类须继承该类
 * 
 * @author tom
 *
 * @date 2015年11月30日 下午4:49:23
 * @type BaseDto
 */
public class WebServiceBaseResultVo {

	// webService的业务状态，当程序发生异常被捕获，或输入参数不正确的情况下请返回FAIL，默认为SUCCESS
	private APIStatus status = APIStatus.SUCCESS;

	// 理由，当程序出现异常被捕获或输入参数不正确的情况下，请填写该字段。
	private String reason;

	// 异常信息，当程序出现异常时，请将堆栈信息填入该字段
	private String exception;

	// 接口执行时间，默认为创建对象时间
	private Long date = System.currentTimeMillis();

	/**
	 * 获取状态
	 * 
	 * @return
	 */
	public APIStatus getStatus() {
		return status;
	}

	/**
	 * 设置状态
	 * 
	 * @param status
	 */
	public void setStatus(APIStatus status) {
		this.status = status;
	}

	/**
	 * 获取理由
	 * 
	 * @return
	 */
	public String getReason() {
		return reason;
	}

	/**
	 * 设置理由
	 * 
	 * @param reason
	 */
	public void setReason(String reason) {
		this.reason = reason;
	}

	/**
	 * 获取异常信息
	 * 
	 * @return
	 */
	public String getException() {
		return exception;
	}

	/**
	 * 设置异常信息
	 * 
	 * @param exception
	 */
	public void setException(String exception) {
		this.exception = exception;
	}

	/**
	 * 获取时间戳 初始值为对象创建时间
	 * 
	 * @return
	 */
	public Long getDate() {
		return date;
	}

	/**
	 * 设置时间戳 初始值为对象创建时间
	 * 
	 * @param date
	 */
	public void setDate(Long date) {
		this.date = date;
	}
}
