/**
 * @Description: 
 * @ClassName: com.biz.commondocker.productinfodocker.service.ProductInfoApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年3月10日 下午9:12:00 
 */
package com.biz.interfacedocker.middledocker.service;

import java.util.List;

import com.biz.interfacedocker.common.page.PageInfo;
import com.biz.interfacedocker.middledocker.vo.BarCodeSynDto;
import com.biz.interfacedocker.middledocker.vo.BcBaseInfoTmpVo;


/**
 * 中间库二维码 服务api 接口
 * @date: 2016年3月10日 下午9:12:00 
 *
 */
public interface Bar2CodeMiddleDbApiService {
	
	/**
	 * 分页查询包码信息
	 * @param baseInfoVo 查询条件
	 * @param rows  每页显示的记录数
	 * @param page  当前页
	 * @return map  key rows-List对象   total-总记录数  page-当前页
	 */
	public PageInfo<BcBaseInfoTmpVo> findBcBaseInfoTmpByPage(BcBaseInfoTmpVo baseInfoVo,int rows,int page);
	
	/**
	 * 根据包码范围查询包码信息
	 * @param startPkgNo 开始包码
	 * @param endPkgNo  结束包码
	 * @return
	 */
	public List<BcBaseInfoTmpVo> findBcBaseInfoTmprangeList(String startPkgNo,String endPkgNo);
	
	
	/***
	 * 分页查询包码信息
	 * @param baseInfoVo 查询条件
	 * @param rows  每页显示的记录数
	 * @param page  当前页
	 * @return map  key rows-List对象   total-总记录数  page-当前页
	 */
	public PageInfo<BcBaseInfoTmpVo> findPkgInfoByPage(BcBaseInfoTmpVo baseInfoVo,int rows,int page);
	
	/**
	 * 批量更新包码给供应商
	 * @param list
	 * @return
	 */
	int updateBatchPkgInfo(List<BcBaseInfoTmpVo> list);
	
	/**
	 * 批量更新包码给门店
	 * @param list
	 * @return
	 */
	int updateBatchPkgInfo2Mcu(List<BcBaseInfoTmpVo> list);
	
	/***
	 * 根据包码查询包码所对应的所有二维码信息
	 * @param pkgNo 包码
	 */
	public List<BcBaseInfoTmpVo> findBcBaseInfoTmpByPkgNo(String pkgNo);
	
	
	
	/***
	 * 根据条件查询包码信息
	 * @param pkgNo 包码
	 * @param est  1-品牌公司  2-省公司
	 * @param userId  当前用户
	 */
	public BcBaseInfoTmpVo findPkgInfoByPkgNo(String pkgNo,String est,String userId);
	
	/**
	 * 根据包码信息查询没有同步到本地的二维码信息
	 */
	public List<BcBaseInfoTmpVo> findNoTransPagkgeNo();
	/**
	 * 更新传输状态
	 * @author gaopan
	 * @date 2016年7月25日 下午5:18:47
	 * @param pkgNo
	 * @return
	 */
	int updateBatchPkgInfoStatus(String pkgNo);
	
   /***
    * 根据包码查询，包码的传输状态
    */
	int findPkgTransStatus(String pkgNo);
	/***
	 * 根据包码查询未被同步的二维码
	 * @param pkgNo
	 * @return
	 */
	public List<BarCodeSynDto> queryBar2CodeByPageNo(String pkgNo);
}
