/**
 * @Description: 
 * @ClassName: com.biz.commondocker.productinfodocker.service.ProductInfoApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年3月10日 下午9:12:00 
 */
package com.biz.interfacedocker.middledocker.service;

import java.util.List;
import java.util.Map;

import com.biz.interfacedocker.common.page.PageInfo;
import com.biz.interfacedocker.middledocker.vo.ProductInfoMiddleDbVo;

/**
 * 商品主数据信息 服务api 接口
 * @Description: MiddleDb 表示来源于 中间库服务
 * @ClassName: com.biz.commondocker.productinfodocker.service.ProductInfoApiService
 * @author: Omar(OmarZhang)
 * @date: 2016年3月10日 下午9:12:00 
 *
 */
public interface ProductInfoMiddleDbApiService {
	
	/**
	 * 根据商品编号获取商品主数据信息
	 * @Title: findByProductSn 
	 * @param productSn 商品编号
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月10日 下午9:22:15
	 */
	public ProductInfoMiddleDbVo findByProductSn(String productSn);
	
	/**
	 * 根据商品编号(集合) 获取商品主数据信息
	 * @Title: findsByProductSn 
	 * @param productSns 商品主数据信息(集合)
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月10日 下午9:24:41
	 */
	public List<ProductInfoMiddleDbVo> findsByProductSn(String... productSns);
	
	/**
	 * 根据条数进行获取商品主数据信息
	 * @Title: findsByProductSn 
	 * @param startNum 从第几条开始.如果为null,默认从0开始
	 * @param endNum 从地几条数据结束,如果为null,默认为1000.
	 * @return List<ProductInfoMiddleDbVo> 最大返回条数1000
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月11日 下午4:27:06
	 */
	public List<ProductInfoMiddleDbVo> findsByProduct(Integer startNum,Integer endNum);

	/**
	 * 根据商品名称获取
	 * 商品基本信息.
	 * @Title: searchProductByName 
	 * @param productName 商品名称
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年3月28日 下午5:00:21
	 */
	public List<ProductInfoMiddleDbVo> searchProductByName(String productName);
	
	/**
	 * 分页查询
	 * @Title: findPage 
	 * @param pageInfo 分页信息
	 * @param queryCondition 查询条件 均为 LIKE 
	 * 通过OR 实现
	 * @return 返回的 PageInfo
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月9日 上午11:12:55
	 */
	PageInfo<ProductInfoMiddleDbVo> findPage(PageInfo<ProductInfoMiddleDbVo> pageInfo,Map<String,Object> queryCondition);
	
	
}
