package com.biz.interfacedocker.orderdocker.service;

import com.biz.interfacedocker.common.page.Pageable;
import com.biz.interfacedocker.orderdocker.vo.orderlist.OrderBaseRespVo;
import com.biz.interfacedocker.orderdocker.vo.orderlist.OrderLogisticsRespVo;
import com.biz.interfacedocker.orderdocker.vo.orderlist.ShopInfoRespVo;

import java.util.List;

public interface OrderApiService {
    /**
     * 分页查询自动订单
     *
     * @param pageable Pageable
     * @return List<OrderBaseRespVo>
     */
    List<OrderBaseRespVo> findAutoOrderPage(Pageable pageable);

    /**
     * 获取所有门店信息
     *
     * @return List<ShopInfoRespVo>
     */
    List<ShopInfoRespVo> getAllShopInfo();

    /**
     * 通过订单编号查询详细信息
     *
     * @param orderBn 订单编号
     * @return OrderBaseRespVo
     */
    OrderBaseRespVo findSimpleOrderByOrderBn(String orderBn);

    /**
     * 查询全部已有的物流公司
     *
     * @return OrderLogisticsRespVo
     */
    List<OrderLogisticsRespVo> findAllLogisticCompany();

    /**
     * 查询全部已有的支付方式
     *
     * @return OrderBaseRespVo
     */
    List<OrderBaseRespVo> findAllPayBn();
}
