/**
 * @Description: 
 * @ClassName: com.biz.orderDocker.vo.OrderItemVo
 * @author: Omar(OmarZhang)
 * @date: 2016年2月29日 下午2:30:22 
 */
package com.biz.interfacedocker.orderdocker.vo.orderlist;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 订单项Vo
 * @Description: 
 * @ClassName: com.biz.orderDocker.vo.OrderItemVo
 * @author: Omar(OmarZhang)
 * @date: 2016年2月29日 下午2:30:22 
 *
 */
public class OrderItemRespVo implements Serializable{

	/**
	 * @Fields serialVersionUID : TODO
	 */
	private static final long serialVersionUID = 1L;
	
	/** 商品ID*/
	private Integer id;
	/** 商品编号*/
	private String bn;
	/** 商品名称*/
	private String name;
	/** 商品数量*/
	private Integer quantity;
	/**商品ID*/
	private Integer orderId;
	/**商品编号*/
	private String orderBn;
	/** 商品原价*/
	private BigDecimal price;
	/** 商品总价*/
	private BigDecimal amount;
	/** 商品重量*/
	private BigDecimal weight;
	/** 商品购买价格*/
	private BigDecimal g_price;
	/** 商品/赠品*/
	private String productType;
	/** 商品类型(商品/赠品) 0: 商品 1 赠品*/
	private Integer productTypeInt;
	/** 是否属于自身维护编号,
	 *  如果为true 则表示该编号是自身维护 需要从数据库中
	 *  根据短编号进行查询获取
	 * */
	private Boolean isOwnBn;
	/** 组合商品 拆分之后的商品信息*/
	private List<ProductInfoRespVo> splitProducts = new ArrayList<ProductInfoRespVo>();
	
	
	public Integer getId() {
		return id;
	}
	public void setId(Integer id) {
		this.id = id;
	}
	/**
	 * @return the bn
	 */
	public String getBn() {
		return bn;
	}
	/**
	 * @param bn the bn to set
	 */
	public void setBn(String bn) {
		this.bn = bn;
	}
	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @return the quantity
	 */
	public Integer getQuantity() {
		return quantity;
	}
	/**
	 * @param quantity the quantity to set
	 */
	public void setQuantity(Integer quantity) {
		this.quantity = quantity;
	}
	/**
	 * @return the price
	 */
	public BigDecimal getPrice() {
		return price;
	}
	/**
	 * @param price the price to set
	 */
	public void setPrice(BigDecimal price) {
		this.price = price;
	}
	/**
	 * @return the amount
	 */
	public BigDecimal getAmount() {
		return amount;
	}
	/**
	 * @param amount the amount to set
	 */
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
	/**
	 * @return the weight
	 */
	public BigDecimal getWeight() {
		return weight;
	}
	/**
	 * @param weight the weight to set
	 */
	public void setWeight(BigDecimal weight) {
		this.weight = weight;
	}
	/**
	 * @return the g_price
	 */
	public BigDecimal getG_price() {
		return g_price;
	}
	/**
	 * @param g_price the g_price to set
	 */
	public void setG_price(BigDecimal g_price) {
		this.g_price = g_price;
	}
	/**
	 * @return the productType
	 */
	public String getProductType() {
		return productType;
	}
	/**
	 * @param productType the productType to set
	 */
	public void setProductType(String productType) {
		this.productType = productType;
	}
	/**
	 * @return the isOwnBn
	 */
	public Boolean getIsOwnBn() {
		return isOwnBn;
	}
	/**
	 * @param isOwnBn the isOwnBn to set
	 */
	public void setIsOwnBn(Boolean isOwnBn) {
		this.isOwnBn = isOwnBn;
	}
	/**
	 * @return the productTypeInt
	 */
	public Integer getProductTypeInt() {
		return productTypeInt;
	}
	/**
	 * @param productTypeInt the productTypeInt to set
	 */
	public void setProductTypeInt(Integer productTypeInt) {
		this.productTypeInt = productTypeInt;
	}

	public Integer getOrderId() {
		return orderId;
	}
	public void setOrderId(Integer orderId) {
		this.orderId = orderId;
	}
	public String getOrderBn() {
		return orderBn;
	}
	public void setOrderBn(String orderBn) {
		this.orderBn = orderBn;
	}
	/**
	 * @return the splitProducts
	 */
	public List<ProductInfoRespVo> getSplitProducts() {
		return splitProducts;
	}
	/**
	 * @param splitProducts the splitProducts to set
	 */
	public void setSplitProducts(List<ProductInfoRespVo> splitProducts) {
		this.splitProducts = splitProducts;
	}
	
	/**
	 * @Title: hashCode 
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月27日 下午5:20:10
	 * @see Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((bn == null) ? 0 : bn.hashCode());
		result = prime * result + ((g_price == null) ? 0 : g_price.hashCode());
		result = prime * result + ((quantity == null) ? 0 : quantity.hashCode());
		return result;
	}
	/**
	 * @Title: equals
	 * @param obj
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月27日 下午5:20:10
	 * @see Object#equals(Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		OrderItemRespVo other = (OrderItemRespVo) obj;
		if (bn == null) {
			if (other.bn != null)
				return false;
		} else if (!bn.equals(other.bn))
			return false;
		if (g_price == null) {
			if (other.g_price != null)
				return false;
		} else if (g_price.compareTo(other.g_price) != 0)
			return false;
		if (quantity == null) {
			if (other.quantity != null)
				return false;
		} else if (!quantity.equals(other.quantity))
			return false;
		return true;
	}
	
	
	
	
}
