/*
 * Decompiled with CFR 0.152.
 */
package com.biz.interfacedocker.common.util;

import com.biz.interfacedocker.common.JsonResult;
import com.biz.interfacedocker.common.type.HttpResultStatus;
import java.util.HashMap;
import java.util.Map;

public class ServiceUtil {
    public static <T> JsonResult<T> returnSuccess(T t) {
        return new JsonResult<T>(HttpResultStatus.EXECUTE_SUCCESS, t);
    }

    public static <T> JsonResult<T> returnParamError(String code_msg) {
        JsonResult jsonResult = new JsonResult(HttpResultStatus.PARAMETER_ERROR, code_msg);
        return jsonResult;
    }

    public static <T> JsonResult<T> returnSystemError(String code_msg) {
        JsonResult jsonResult = new JsonResult(HttpResultStatus.SYSTEM_ERROR, code_msg);
        return jsonResult;
    }

    public static <T> JsonResult<T> returnError(HttpResultStatus status, String code_msg) {
        JsonResult jsonResult = new JsonResult(status, code_msg);
        return jsonResult;
    }

    public static <T> JsonResult<Map<String, Object>> returnSuccessWithPage(T t, int page, int pageSize) {
        HashMap<String, Integer> respWithPage = new HashMap<String, Integer>();
        respWithPage.put("page", page);
        respWithPage.put("pageSize", pageSize);
        respWithPage.put("data", (Integer)t);
        return new JsonResult<Map<String, Object>>(HttpResultStatus.EXECUTE_SUCCESS, respWithPage);
    }

    public static <T> JsonResult<Map<String, Object>> returnSuccessWithOrderPage(T t, int page, int pageSize, String subMsg) {
        HashMap<String, Integer> respWithPage = new HashMap<String, Integer>();
        respWithPage.put("page", page);
        respWithPage.put("pageSize", pageSize);
        respWithPage.put("data", (Integer)t);
        return new JsonResult<Map<String, Object>>(HttpResultStatus.EXECUTE_SUCCESS, subMsg, respWithPage);
    }

    public static <T> JsonResult<Map<String, Object>> returnSuccessWithJdePage(T t, int page, int pageSize, Integer jdePageNo, long count, long totalPage) {
        HashMap<String, Number> respWithPage = new HashMap<String, Number>();
        respWithPage.put("page", page);
        respWithPage.put("pageSize", pageSize);
        respWithPage.put("data", (Number)t);
        respWithPage.put("jdePageNo", jdePageNo);
        respWithPage.put("count", count);
        respWithPage.put("totalPage", totalPage);
        return new JsonResult<Map<String, Object>>(HttpResultStatus.EXECUTE_SUCCESS, respWithPage);
    }

    public static <T> JsonResult<Map<String, Object>> returnSuccessWithPage(T t, int page, int pageSize, long count, long totalPage) {
        HashMap<String, Number> respWithPage = new HashMap<String, Number>();
        respWithPage.put("page", page);
        respWithPage.put("pageSize", pageSize);
        respWithPage.put("data", (Number)t);
        respWithPage.put("count", count);
        respWithPage.put("totalPage", totalPage);
        return new JsonResult<Map<String, Object>>(HttpResultStatus.EXECUTE_SUCCESS, respWithPage);
    }
}

