/*
 * Decompiled with CFR 0.152.
 */
package com.biz.redis.bean;

import com.biz.redis.bean.BaseRo;
import com.biz.redis.bean.RedisObjMap;
import com.biz.redis.model.Identifiable;
import com.biz.redis.model.PropertyDescriptorExtends;
import com.biz.redis.util.ReflectionUtil;
import com.google.common.base.Objects;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRedisObject<ID extends Serializable>
extends BaseRo
implements Identifiable<ID> {
    private static final ConcurrentHashMap<Class<?>, List<PropertyDescriptorExtends>> supportedPropertyMap = new ConcurrentHashMap();
    private static final Set<Class<?>> supportedClass = new HashSet();
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private ID id;
    private Timestamp createTimestamp = new Timestamp(System.currentTimeMillis());
    private Timestamp updateTimestamp;

    private List<PropertyDescriptorExtends> getSupportedProperties() {
        List<PropertyDescriptorExtends> result = supportedPropertyMap.get(this.getClass());
        if (result == null) {
            try {
                BeanInfo bi = Introspector.getBeanInfo(this.getClass(), Object.class);
                PropertyDescriptor[] pds = bi.getPropertyDescriptors();
                result = new ArrayList<PropertyDescriptorExtends>();
                supportedPropertyMap.put(this.getClass(), result);
                for (PropertyDescriptor pd : pds) {
                    if (pd.getPropertyType() == null) {
                        this.log.error("class[{}], property[{}] type is null", this.getClass(), (Object)pd);
                    }
                    if (supportedClass.contains(pd.getPropertyType()) || Enum.class.isAssignableFrom(pd.getPropertyType())) {
                        if (Objects.equal((Object)"id", (Object)pd.getName())) {
                            this.log.debug("{} ro id descriptor is {}", this.getClass(), (Object)pd);
                        }
                        result.add(new PropertyDescriptorExtends(pd));
                        continue;
                    }
                    this.log.warn("not support ro [{}] property {}", this.getClass(), (Object)pd.getName());
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        return result;
    }

    public void fromMap(Map<byte[], byte[]> map) {
        RedisObjMap objMap = new RedisObjMap(map);
        List<PropertyDescriptorExtends> pds = this.getSupportedProperties();
        for (PropertyDescriptorExtends pd : pds) {
            String name = pd.getName();
            Class<?> type = pd.getPropertyType();
            Object value = null;
            Method writer = pd.getWriteMethod();
            if (writer == null) continue;
            try {
                Long time;
                if (type == Integer.class || type == Integer.TYPE) {
                    value = objMap.getInt(name);
                } else if (type == Long.class || type == Long.TYPE) {
                    value = objMap.getLong(name);
                } else if (type == String.class) {
                    value = objMap.getString(name);
                } else if (type == Boolean.class || type == Boolean.TYPE) {
                    value = objMap.getBoolean(name);
                } else if (type == Byte.class || type == Byte.TYPE) {
                    value = objMap.getByte(name);
                } else if (type == Short.class || type == Short.TYPE) {
                    value = objMap.getShort(name);
                } else if (type == BigDecimal.class) {
                    value = objMap.getBigDecimal(name, 8);
                } else if (type == Timestamp.class) {
                    time = objMap.getLong(name);
                    value = time == null ? null : new Timestamp(time);
                } else if (type == java.util.Date.class) {
                    time = objMap.getLong(name);
                    value = time == null ? null : new java.util.Date(time);
                } else if (type == Time.class) {
                    time = objMap.getLong(name);
                    value = time == null ? null : new Time(time);
                } else if (type == Date.class) {
                    time = objMap.getLong(name);
                    value = time == null ? null : new Date(time);
                } else if (Enum.class.isAssignableFrom(type)) {
                    String enumName = objMap.getString(name);
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{enumName})) {
                        value = EnumUtils.getEnum(type, (String)enumName);
                    }
                } else {
                    this.log.error("\u4e0d\u80fd\u8bc6\u522b\u7684\u5c5e\u6027,ro={},name={},class={}", new Object[]{this.getClass(), name, type});
                }
                writer.invoke((Object)this, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                this.log.warn("Can not set {} to {}.{}", new Object[]{value, this.getClass().getName(), name, e});
            }
        }
    }

    public Map<byte[], byte[]> toMap() {
        RedisObjMap map = new RedisObjMap();
        List<PropertyDescriptorExtends> pds = this.getSupportedProperties();
        for (PropertyDescriptorExtends pd : pds) {
            String name = pd.getName();
            Class<?> type = pd.getPropertyType();
            Method reader = pd.getReadMethod();
            if (reader == null) continue;
            try {
                Object value = reader.invoke((Object)this, new Object[0]);
                if (type == Integer.class || type == Integer.TYPE) {
                    map.put(name, (Integer)value);
                    continue;
                }
                if (type == Long.class || type == Long.TYPE) {
                    map.put(name, (Long)value);
                    continue;
                }
                if (type == String.class) {
                    map.put(name, (String)value);
                    continue;
                }
                if (type == Boolean.class || type == Boolean.TYPE) {
                    map.put(name, (Boolean)value);
                    continue;
                }
                if (type == Byte.class || type == Byte.TYPE) {
                    map.put(name, (Byte)value);
                    continue;
                }
                if (type == Short.class || type == Short.TYPE) {
                    map.put(name, (Short)value);
                    continue;
                }
                if (type == BigDecimal.class) {
                    map.put(name, (BigDecimal)value, 8);
                    continue;
                }
                if (type == java.util.Date.class || type == Timestamp.class || type == Date.class || type == Time.class) {
                    java.util.Date ts = (java.util.Date)value;
                    map.put(name, ts == null ? null : Long.valueOf(ts.getTime()));
                    continue;
                }
                if (!Enum.class.isAssignableFrom(type)) continue;
                map.put(name, value == null ? null : ((Enum)value).name());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                this.log.warn("Can not get value of {}.{}", new Object[]{this.getClass().getName(), name, e});
            }
        }
        return map.getSerialMap();
    }

    private Type getIdType(Type type) {
        if (type == Serializable.class) {
            Class clz = ReflectionUtil.findGenericParameter(this.getClass(), 0);
            if (clz == null && (clz = ReflectionUtil.findGenericParameter(this.getClass().getSuperclass(), 0)) == null) {
                this.log.error("\u6ca1\u6709\u83b7\u53d6\u5230ro id\u7684\u7c7b\u578b,ro class={}", this.getClass());
            }
            return clz;
        }
        return type;
    }

    @Override
    public ID getId() {
        return this.id;
    }

    @Override
    public void setId(ID id) {
        this.id = id;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        this.createTimestamp = createTimestamp;
    }

    public Timestamp getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
    }

    static {
        supportedClass.add(Integer.class);
        supportedClass.add(Integer.TYPE);
        supportedClass.add(Long.class);
        supportedClass.add(Long.TYPE);
        supportedClass.add(String.class);
        supportedClass.add(Boolean.class);
        supportedClass.add(Boolean.TYPE);
        supportedClass.add(Byte.class);
        supportedClass.add(Byte.TYPE);
        supportedClass.add(Short.class);
        supportedClass.add(Short.TYPE);
        supportedClass.add(BigDecimal.class);
        supportedClass.add(Timestamp.class);
        supportedClass.add(Time.class);
        supportedClass.add(java.util.Date.class);
        supportedClass.add(Date.class);
    }
}

