/*
 * Decompiled with CFR 0.152.
 */
package com.biz.redis.cluster;

import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedisCluster;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSlotBasedConnectionHandler;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.exceptions.JedisRedirectionException;
import redis.clients.util.JedisClusterCRC16;
import redis.clients.util.SafeEncoder;

public class JedisClusterPipeline
extends PipelineBase
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(JedisClusterPipeline.class);
    private static final Field FIELD_CONNECTION_HANDLER = JedisClusterPipeline.getField(BinaryJedisCluster.class, "connectionHandler");
    private static final Field FIELD_CACHE = JedisClusterPipeline.getField(JedisClusterConnectionHandler.class, "cache");
    private JedisSlotBasedConnectionHandler connectionHandler;
    private Queue<Client> clients = new LinkedList<Client>();
    private Map<JedisPool, Jedis> jedisMap = new HashMap<JedisPool, Jedis>();

    public static JedisClusterPipeline pipelined(JedisCluster jedisCluster) {
        JedisClusterPipeline pipeline = new JedisClusterPipeline();
        pipeline.setJedisCluster(jedisCluster);
        return pipeline;
    }

    public void setJedisCluster(JedisCluster jedis) {
        JedisSlotBasedConnectionHandler ch = (JedisSlotBasedConnectionHandler)JedisClusterPipeline.getValue(jedis, FIELD_CONNECTION_HANDLER);
        if (null == ch) {
            throw new RuntimeException("cannot get JedisSlotBasedConnectionHandler from JedisCluster");
        }
        this.connectionHandler = ch;
    }

    public void refreshCluster() {
        this.connectionHandler.renewSlotCache();
    }

    public void sync() {
        this.innerSync(null);
    }

    public List<Object> syncAndReturnAll() {
        ArrayList<Object> responseList = new ArrayList<Object>();
        this.innerSync(responseList);
        return responseList;
    }

    private void innerSync(List<Object> formatted) {
        block14: {
            HashSet<Client> clientSet = new HashSet<Client>();
            try {
                for (Client client : this.clients) {
                    Object data = this.generateResponse(client.getOne()).get();
                    if (null != formatted) {
                        formatted.add(data);
                    }
                    if (clientSet.size() == this.jedisMap.size()) continue;
                    clientSet.add(client);
                }
                if (clientSet.size() == this.jedisMap.size()) break block14;
            }
            catch (JedisRedirectionException jre) {
                try {
                    if (jre instanceof JedisMovedDataException) {
                        this.refreshCluster();
                    }
                    throw jre;
                }
                catch (Throwable throwable) {
                    if (clientSet.size() != this.jedisMap.size()) {
                        for (Jedis jedis : this.jedisMap.values()) {
                            if (clientSet.contains(jedis.getClient())) continue;
                            try {
                                jedis.getClient().getAll();
                            }
                            catch (RuntimeException runtimeException) {}
                        }
                    }
                    this.close();
                    throw throwable;
                }
            }
            for (Jedis jedis : this.jedisMap.values()) {
                if (clientSet.contains(jedis.getClient())) continue;
                try {
                    jedis.getClient().getAll();
                }
                catch (RuntimeException runtimeException) {}
            }
        }
        this.close();
    }

    @Override
    public void close() {
        this.clean();
        this.clients.clear();
        for (Jedis jedis : this.jedisMap.values()) {
            jedis.close();
        }
        this.jedisMap.clear();
    }

    protected Client getClient(String key) {
        byte[] bKey = SafeEncoder.encode((String)key);
        return this.getClient(bKey);
    }

    protected Client getClient(byte[] key) {
        Jedis jedis = this.getJedis(JedisClusterCRC16.getSlot((byte[])key));
        Client client = jedis.getClient();
        this.clients.add(client);
        return client;
    }

    private Jedis getJedis(int slot) {
        JedisClusterInfoCache cache = (JedisClusterInfoCache)JedisClusterPipeline.getValue(this.connectionHandler, FIELD_CACHE);
        JedisPool pool = cache.getSlotPool(slot);
        Jedis jedis = this.jedisMap.get(pool);
        if (null == jedis) {
            jedis = pool.getResource();
            this.jedisMap.put(pool, jedis);
        }
        return jedis;
    }

    private static Field getField(Class<?> cls, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("cannot find or access field '" + fieldName + "' from " + cls.getName(), e);
        }
    }

    private static <T> T getValue(Object obj, Field field) {
        try {
            return (T)field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.error("get value fail", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

