/*
 * Decompiled with CFR 0.152.
 */
package com.biz.redis.dao;

import com.biz.redis.annotation.FieldSortedSet;
import com.biz.redis.annotation.MethodSortedSet;
import com.biz.redis.annotation.Ro;
import com.biz.redis.annotation.RoLock;
import com.biz.redis.annotation.RoSortedSet;
import com.biz.redis.bean.BaseRedisObject;
import com.biz.redis.spi.JedisRedis;
import com.biz.redis.util.ExpressionUtil;
import com.biz.redis.util.RedisUtil;
import com.biz.redis.util.SortedSetAssist;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBase;
import redis.clients.util.Pool;

public class JedisCurdCommonRedisDao<T extends BaseRedisObject<ID>, ID extends Serializable>
extends JedisRedis {
    private static final String SEPARATOR = ":";
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private String keyPrefix = null;
    private boolean isExistRo = false;
    private String roLockKeyPrefix = null;
    private boolean isExistRoLock = false;
    private RoLock roLock = null;
    private String roSortedSetKey = null;
    private boolean isExistRoSortedSet = false;
    private RoSortedSet roSortedSet = null;
    Expression expression = null;
    Map<String, FieldSortedSet> fieldName_Annotation_Map = null;
    Map<FieldSortedSet, SortedSetAssist<T, ID>> fieldInSortedSetMap = null;
    Map<String, MethodSortedSet> methodName_Annotation_Map = null;
    Map<MethodSortedSet, SortedSetAssist<T, ID>> methodInSortedSetMap = null;

    public String getKeyByParams(Object ... params) {
        StringBuffer key = new StringBuffer(this.getKeyPrefix());
        if (params != null && params.length > 0) {
            for (Object param : params) {
                this.logger.debug("ShardedJedisCurdCommonRedisDao>>getKeyByParams>>params:{},param:{}", (Object)params, param);
                key.append(SEPARATOR).append(param.toString());
            }
        }
        return key.toString();
    }

    public String getFieldSortedSetKey(String fieldName, Object fieldValue) {
        String value;
        StringBuffer key = new StringBuffer();
        FieldSortedSet fieldSortedSet = this.fieldName_Annotation_Map.get(fieldName);
        if (fieldSortedSet == null) {
            throw new RuntimeException("[" + fieldName + "]--> FieldSortedSet is null");
        }
        String string = value = fieldValue != null ? fieldValue.toString() : "";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Field -> [{}], Value -> [{}]", (Object)fieldName, (Object)value);
        }
        if ("".equals(fieldSortedSet.prefix())) {
            key.append(this.getKeyPrefix()).append(SEPARATOR).append(fieldName).append(SEPARATOR).append(value);
        } else {
            key.append(fieldSortedSet.prefix()).append(SEPARATOR).append(fieldName).append(SEPARATOR).append(value);
        }
        return key.toString();
    }

    public String getMethodSortedSetKey(String methodName, Object fieldValue) {
        String value;
        StringBuffer key = new StringBuffer();
        MethodSortedSet methodSortedSet = this.methodName_Annotation_Map.get(methodName);
        if (methodSortedSet == null) {
            throw new RuntimeException("[" + methodName + "]--> MethodSortedSet is null");
        }
        String string = value = fieldValue != null ? fieldValue.toString() : "";
        if (methodSortedSet.prefix().equals("")) {
            key.append(this.getKeyPrefix()).append(SEPARATOR).append(methodName).append(SEPARATOR).append(value);
        } else {
            key.append(methodSortedSet.prefix()).append(SEPARATOR).append(methodName).append(SEPARATOR).append(value);
        }
        return key.toString();
    }

    public String getKeyPrefix() {
        return this.keyPrefix.toString();
    }

    public String getRoSortedSetKey() {
        return this.roSortedSetKey.toString();
    }

    public String getHashKey(Serializable id) {
        return new StringBuffer(this.getKeyPrefix()).append(SEPARATOR).append(id).toString();
    }

    public String getHashKeyFromIdByte(byte[] byteId) {
        return new StringBuffer(this.getKeyPrefix()).append(SEPARATOR).append(new String(byteId)).toString();
    }

    public String getRoLockKeyPrefix() {
        return this.roLockKeyPrefix.toString();
    }

    public String getLockHashKey(Serializable id) {
        return new StringBuffer(this.getRoLockKeyPrefix()).append(SEPARATOR).append(id).toString();
    }

    public String getLockHashKeyFromIdByte(byte[] byteId) {
        return new StringBuffer(this.getRoLockKeyPrefix()).append(SEPARATOR).append(new String(byteId)).toString();
    }

    public String getRoLockKeyByParams(Object ... params) {
        StringBuffer key = new StringBuffer(this.getRoLockKeyPrefix());
        if (params != null && params.length > 0) {
            for (Object param : params) {
                key.append(SEPARATOR).append(param.toString());
            }
        }
        return key.toString();
    }

    public JedisCurdCommonRedisDao() {
        Ro ro = this.entityClass.getAnnotation(Ro.class);
        boolean bl = this.isExistRo = ro != null;
        if (!this.isExistRo) {
            throw new RuntimeException("not find Ro annotation");
        }
        this.keyPrefix = ro.key().intern();
        this.roLock = this.entityClass.getAnnotation(RoLock.class);
        boolean bl2 = this.isExistRoLock = this.roLock != null;
        if (this.isExistRoLock) {
            this.roLockKeyPrefix = this.roLock.key().intern();
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        this.roSortedSet = this.entityClass.getAnnotation(RoSortedSet.class);
        boolean bl3 = this.isExistRoSortedSet = this.roSortedSet != null;
        if (this.isExistRoSortedSet) {
            this.roSortedSetKey = (this.getKeyPrefix() + SEPARATOR + this.roSortedSet.key()).intern();
            if (StringUtils.isNotBlank((CharSequence)this.roSortedSet.score())) {
                this.expression = parser.parseExpression(this.roSortedSet.score());
            }
        }
        if (this.entityClass != null) {
            Method[] methods;
            Field[] fields = this.entityClass.getDeclaredFields();
            if (fields != null && fields.length > 0) {
                for (Field field : fields) {
                    boolean isExistFieldSortedSet;
                    if (Modifier.isFinal(field.getModifiers())) continue;
                    field.setAccessible(true);
                    FieldSortedSet fieldSortedSet = field.getAnnotation(FieldSortedSet.class);
                    boolean bl4 = isExistFieldSortedSet = fieldSortedSet != null;
                    if (!isExistFieldSortedSet) continue;
                    if (this.fieldInSortedSetMap == null) {
                        this.fieldInSortedSetMap = new HashMap<FieldSortedSet, SortedSetAssist<T, ID>>();
                    }
                    if (this.fieldName_Annotation_Map == null) {
                        this.fieldName_Annotation_Map = new HashMap<String, FieldSortedSet>();
                    }
                    this.fieldInSortedSetMap.put(fieldSortedSet, new SortedSetAssist(field.getName(), StringUtils.isBlank((CharSequence)fieldSortedSet.prefix()) ? this.getKeyPrefix() + SEPARATOR + field.getName() : fieldSortedSet.prefix() + SEPARATOR + field.getName(), parser.parseExpression(fieldSortedSet.key()), StringUtils.isNotBlank((CharSequence)fieldSortedSet.score()) ? parser.parseExpression(fieldSortedSet.score()) : null));
                    this.fieldName_Annotation_Map.put(field.getName(), fieldSortedSet);
                }
            }
            if ((methods = this.entityClass.getMethods()) != null && methods.length > 0) {
                for (Method method : methods) {
                    boolean isExistMethodSortedSet;
                    if (Modifier.isFinal(method.getModifiers())) continue;
                    method.setAccessible(true);
                    MethodSortedSet methodSortedSet = method.getAnnotation(MethodSortedSet.class);
                    boolean bl5 = isExistMethodSortedSet = methodSortedSet != null;
                    if (!isExistMethodSortedSet) continue;
                    if (this.methodInSortedSetMap == null) {
                        this.methodInSortedSetMap = new HashMap<MethodSortedSet, SortedSetAssist<T, ID>>();
                    }
                    if (this.methodName_Annotation_Map == null) {
                        this.methodName_Annotation_Map = new HashMap<String, MethodSortedSet>();
                    }
                    this.methodInSortedSetMap.put(methodSortedSet, new SortedSetAssist(method.getName(), StringUtils.isBlank((CharSequence)methodSortedSet.prefix()) ? this.getKeyPrefix() + SEPARATOR + method.getName() : methodSortedSet.prefix() + SEPARATOR + method.getName(), parser.parseExpression(methodSortedSet.key()), StringUtils.isNotBlank((CharSequence)methodSortedSet.score()) ? parser.parseExpression(methodSortedSet.score()) : null));
                    this.methodName_Annotation_Map.put(method.getName(), methodSortedSet);
                }
            }
        }
    }

    private T instance() {
        try {
            return (T)((BaseRedisObject)this.entityClass.newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public T findOne(ID id) {
        if (id == null) {
            return null;
        }
        Map<byte[], byte[]> map = this.hgetAll(this.getHashKey((Serializable)id));
        if (MapUtils.isNotEmpty(map)) {
            T ro = this.instance();
            ((BaseRedisObject)ro).fromMap(map);
            return ro;
        }
        return null;
    }

    public List<String> getKeyListFromSortedSet(String roSortedSetKey) {
        Set<byte[]> ids = this.zRange(roSortedSetKey, 0L, -1L);
        if (CollectionUtils.isNotEmpty(ids)) {
            ArrayList<String> keys = new ArrayList<String>(ids.size());
            for (byte[] bid : ids) {
                keys.add(this.getHashKeyFromIdByte(bid));
            }
            return keys;
        }
        return Lists.newArrayList();
    }

    public List<String> getKeyListByIdSet(Set<byte[]> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ArrayList<String> keys = new ArrayList<String>(ids.size());
            for (byte[] bid : ids) {
                keys.add(this.getHashKeyFromIdByte(bid));
            }
            return keys;
        }
        return Lists.newArrayList();
    }

    public List<T> findAll() {
        List<String> keys = this.getKeyListFromSortedSet(this.getRoSortedSetKey());
        return this.findByKeys(keys);
    }

    public List<T> findByScoreAsc(Integer page) {
        Set<byte[]> ids = this.zRange(this.getRoSortedSetKey(), Math.max(0, page - 1) * 10, Math.max(1, page) * 10 - 1);
        return this.findByKeys(this.toHashKeys(ids));
    }

    public List<T> findByScoreDesc(Integer page) {
        Set<byte[]> ids = this.zrevrange(this.getRoSortedSetKey(), Math.max(0, page - 1) * 10, Math.max(1, page) * 10 - 1);
        return this.findByKeys(this.toHashKeys(ids));
    }

    private List<String> toHashKeys(Collection<byte[]> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ArrayList<String> keys = new ArrayList<String>(ids.size());
            for (byte[] bid : ids) {
                keys.add(this.getHashKeyFromIdByte(bid));
            }
            return keys;
        }
        return Lists.newArrayList();
    }

    public List<T> findByIds(Iterable<ID> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return Lists.newArrayList();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Serializable id : ids) {
            keys.add(this.getHashKey(id));
        }
        return this.findByKeys(keys);
    }

    public List<T> findByStrIds(Iterable<String> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return Lists.newArrayList();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String id : ids) {
            keys.add(this.getHashKey((Serializable)((Object)id)));
        }
        return this.findByKeys(keys);
    }

    public List<T> findByIds(Set<byte[]> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ArrayList<String> keys = new ArrayList<String>(ids.size());
        for (byte[] id : ids) {
            keys.add(this.getHashKeyFromIdByte(id));
        }
        return this.findByKeys(keys);
    }

    public Map<ID, T> findMapByIds(Iterable<ID> ids) {
        if (ids == null || !ids.iterator().hasNext()) {
            return new HashMap();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Serializable id : ids) {
            keys.add(this.getHashKey(id));
        }
        List<T> list = this.findByKeys(keys);
        if (!CollectionUtils.isEmpty(list)) {
            HashMap<Object, BaseRedisObject> result = new HashMap<Object, BaseRedisObject>();
            for (BaseRedisObject t : list) {
                if (t == null) continue;
                result.put(t.getId(), t);
            }
            return result;
        }
        return new HashMap();
    }

    public Map<ID, T> findMapByIds(Set<byte[]> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return new HashMap();
        }
        ArrayList<String> keys = new ArrayList<String>(ids.size());
        for (byte[] id : ids) {
            keys.add(this.getHashKeyFromIdByte(id));
        }
        List<T> list = this.findByKeys(keys);
        if (!CollectionUtils.isEmpty(list)) {
            HashMap<Object, BaseRedisObject> result = new HashMap<Object, BaseRedisObject>();
            for (BaseRedisObject t : list) {
                if (t == null) continue;
                result.put(t.getId(), t);
            }
            return result;
        }
        return new HashMap();
    }

    public List<T> findByKeys(List<String> keys) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(keys)) {
            List<Object> list = this.pipeHgetall(keys);
            for (int i = 0; i < list.size(); ++i) {
                Map map = (Map)list.get(i);
                if (map == null || map.isEmpty()) continue;
                T ro = this.instance();
                try {
                    ((BaseRedisObject)ro).fromMap(map);
                }
                catch (Exception e) {
                    this.logger.error("ro.fromMap", (Throwable)e);
                }
                result.add(ro);
            }
        }
        return result;
    }

    public T findByKey(String key) {
        Map<byte[], byte[]> map = this.hgetAll(key);
        if (map == null || map.isEmpty()) {
            return null;
        }
        T ro = this.instance();
        try {
            ((BaseRedisObject)ro).fromMap(map);
        }
        catch (Exception e) {
            this.logger.error("ro.fromMap", (Throwable)e);
        }
        return ro;
    }

    public void save(T ro) {
        if (this.isExistRoSortedSet) {
            long score = ExpressionUtil.getScore(new StandardEvaluationContext(ro), this.expression);
            this.zadd(this.getRoSortedSetKey(), score, RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("zadd ({},{})", new Object[]{this.getRoSortedSetKey(), score, ((BaseRedisObject)ro).getId()});
            }
        }
        if (MapUtils.isNotEmpty(this.fieldInSortedSetMap)) {
            for (FieldSortedSet fieldSortedSet : this.fieldInSortedSetMap.keySet()) {
                SortedSetAssist<T, ID> field = this.fieldInSortedSetMap.get(fieldSortedSet);
                this.zadd(field.getKey(ro), field.getScore(ro), RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId()));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("zadd ({},{})", new Object[]{field.getKey(ro), field.getScore(ro), ((BaseRedisObject)ro).getId()});
            }
        }
        if (MapUtils.isNotEmpty(this.methodInSortedSetMap)) {
            for (MethodSortedSet methodSortedSet : this.methodInSortedSetMap.keySet()) {
                SortedSetAssist<T, ID> method = this.methodInSortedSetMap.get(methodSortedSet);
                this.zadd(method.getKey(ro), method.getScore(ro), RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId()));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("zadd ({},{})", new Object[]{method.getKey(ro), method.getScore(ro), ((BaseRedisObject)ro).getId()});
            }
        }
        this.hmset(this.getHashKey((Serializable)((BaseRedisObject)ro).getId()), ((BaseRedisObject)ro).toMap());
    }

    private void save(T ro, PipelineBase pipeline) {
        if (this.isExistRoSortedSet) {
            long score = ExpressionUtil.getScore(new StandardEvaluationContext(ro), this.expression);
            pipeline.zadd(RedisUtil.toByteArray(this.getRoSortedSetKey()), (double)score, RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("zadd ({},{},{})", new Object[]{this.getRoSortedSetKey(), score, ((BaseRedisObject)ro).getId()});
            }
        }
        if (MapUtils.isNotEmpty(this.fieldInSortedSetMap)) {
            for (FieldSortedSet fieldSortedSet : this.fieldInSortedSetMap.keySet()) {
                SortedSetAssist<T, ID> field = this.fieldInSortedSetMap.get(fieldSortedSet);
                pipeline.zadd(RedisUtil.toByteArray(field.getKey(ro)), (double)field.getScore(ro), RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId()));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("zadd ({},{},{})", new Object[]{field.getKey(ro), field.getScore(ro), ((BaseRedisObject)ro).getId()});
            }
        }
        if (MapUtils.isNotEmpty(this.methodInSortedSetMap)) {
            for (MethodSortedSet methodSortedSet : this.methodInSortedSetMap.keySet()) {
                SortedSetAssist<T, ID> method = this.methodInSortedSetMap.get(methodSortedSet);
                pipeline.zadd(RedisUtil.toByteArray(method.getKey(ro)), (double)method.getScore(ro), RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId()));
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("zadd ({},{},{})", new Object[]{method.getKey(ro), method.getScore(ro), ((BaseRedisObject)ro).getId()});
            }
        }
        pipeline.hmset(RedisUtil.toByteArray(this.getHashKey((Serializable)((BaseRedisObject)ro).getId())), ((BaseRedisObject)ro).toMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Iterable<T> ros) {
        StopWatch sw = null;
        if (this.logger.isDebugEnabled()) {
            sw = new StopWatch();
            sw.start();
        }
        Pool<Jedis> pool = this.getPool();
        Jedis jedis = null;
        try {
            jedis = (Jedis)pool.getResource();
            Pipeline jedisPipeline = jedis.pipelined();
            for (BaseRedisObject ro : ros) {
                this.save(ro, (PipelineBase)jedisPipeline);
            }
            jedisPipeline.syncAndReturnAll();
        }
        finally {
            pool.returnResource((Object)jedis);
            if (sw != null) {
                long time = sw.getTime();
                this.logger.debug("redis save iterator usage {} ms", (Object)time);
            }
        }
    }

    public void delete(ID id) {
        this.delete(this.findOne(id));
    }

    public void delete(T ro) {
        if (ro != null) {
            if (this.isExistRoSortedSet) {
                this.zrem(this.getRoSortedSetKey(), new byte[][]{RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId())});
                this.logger.debug("zrem ({},{})", (Object)this.getRoSortedSetKey(), ((BaseRedisObject)ro).getId());
            }
            if (MapUtils.isNotEmpty(this.fieldInSortedSetMap)) {
                for (FieldSortedSet fieldSortedSet : this.fieldInSortedSetMap.keySet()) {
                    SortedSetAssist<T, ID> field = this.fieldInSortedSetMap.get(fieldSortedSet);
                    this.zrem(field.getKey(ro), new byte[][]{RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId())});
                    this.logger.debug("zrem ({},{})", (Object)field.getKey(ro), ((BaseRedisObject)ro).getId());
                }
            }
            if (MapUtils.isNotEmpty(this.methodInSortedSetMap)) {
                for (MethodSortedSet methodSortedSet : this.methodInSortedSetMap.keySet()) {
                    SortedSetAssist<T, ID> method = this.methodInSortedSetMap.get(methodSortedSet);
                    this.zrem(method.getKey(ro), new byte[][]{RedisUtil.toByteArray((Serializable)((BaseRedisObject)ro).getId())});
                    this.logger.debug("zrem ({},{})", (Object)method.getKey(ro), ((BaseRedisObject)ro).getId());
                }
            }
            this.del(this.getHashKey((Serializable)((BaseRedisObject)ro).getId()));
        }
    }

    public boolean isExists(ID id) {
        return this.exists(this.getHashKey((Serializable)id));
    }

    public Long count() {
        if (this.isExistRoSortedSet) {
            return this.zCard(this.getRoSortedSetKey());
        }
        throw new UnsupportedOperationException();
    }

    public void deleteAll() {
        if (this.isExistRoSortedSet) {
            List<String> keys = this.getKeyListFromSortedSet(this.getRoSortedSetKey());
            if (CollectionUtils.isNotEmpty(keys)) {
                for (String key : keys) {
                    super.del(key);
                }
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }
}

