/*
 * Decompiled with CFR 0.152.
 */
package com.biz.redis.spi;

import com.biz.redis.api.ComJedisRedis;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.jedis.Tuple;
import redis.clients.util.Pool;

public class ShardedJedisRedis
implements ComJedisRedis<ShardedJedis> {
    @Autowired(required=false)
    protected ShardedJedisPool shardedJedisPool;

    @Override
    public Pool<ShardedJedis> getPool() {
        return this.shardedJedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] hget(String key, String field) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            byte[] byArray = jedis.hget(key.getBytes(), field.getBytes());
            return byArray;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrby(String key, long increment) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.incrBy(key, increment);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hdel(String key, String field) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.hdel(key.getBytes(), (byte[][])new byte[][]{field.getBytes()});
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long hset(String key, String field, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            long l = jedis.hset(key.getBytes(), field.getBytes(), value);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hsetnx(String key, String field, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            boolean bl = jedis.hsetnx(key.getBytes(), field.getBytes(), value).intValue() == 1;
            return bl;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hmset(String key, Map<byte[], byte[]> hash) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            String string = jedis.hmset(key.getBytes(), hash);
            return string;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> hmget(String key, byte[] ... fields) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            List list = jedis.hmget(key.getBytes(), fields);
            return list;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<byte[], byte[]> hgetAll(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Map map = jedis.hgetAll(key.getBytes());
            return map;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hexists(String key, String field) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            boolean bl = jedis.hexists(key.getBytes(), field.getBytes());
            return bl;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long sadd(String key, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.sadd(key.getBytes(), (byte[][])new byte[][]{value});
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sismember(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            boolean bl = jedis.sismember(key.getBytes(), member);
            return bl;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> smembers(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.smembers(key.getBytes());
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long srem(String key, byte[] members) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.srem(key.getBytes(), (byte[][])new byte[][]{members});
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long del(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.del(key.getBytes());
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            boolean bl = jedis.exists(key.getBytes());
            return bl;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zadd(String key, double score, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long result = jedis.zadd(key.getBytes(), score, member);
            boolean bl = result == 1L || result == 0L;
            return bl;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrem(String key, byte[] ... members) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.zrem(key.getBytes(), members);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrem(String key, String member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.zrem(key.getBytes(), (byte[][])new byte[][]{member.getBytes()});
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zRange(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrange(key.getBytes(), start, end);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrange(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrevrange(key.getBytes(), start, end);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrevrangeWithScore(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrevrangeWithScores(key.getBytes(), start, end);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zangeByScore(String key, String min, String max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrangeByScore(key.getBytes(), min.getBytes(), max.getBytes());
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrangeWithScores(key.getBytes(), start, end);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zCard(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.zcard(key.getBytes());
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zscore(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Double d = jedis.zscore(key.getBytes(), member);
            return d;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer zscoreToInt(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Double d = jedis.zscore(key.getBytes(), member);
            Integer n = d == null ? null : Integer.valueOf(d.intValue());
            return n;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zscoreToLong(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Double d = jedis.zscore(key.getBytes(), member);
            Long l = d == null ? null : Long.valueOf(d.longValue());
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrank(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.zrank(key.getBytes(), member);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Double zincrby(String key, double score, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Double d = jedis.zincrby(key.getBytes(), score, member);
            return d;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(String key, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.rpush(key.getBytes(), (byte[][])new byte[][]{value});
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long rpush(String key, byte[] ... strings) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.rpush(key.getBytes(), strings);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lpush(String key, byte[] ... strings) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.lpush(key.getBytes(), strings);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String ltrim(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            String string = jedis.ltrim(key.getBytes(), start, end);
            return string;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> lrange(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            List list = jedis.lrange(key.getBytes(), start, end);
            return list;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long llen(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            long l = jedis.llen(key.getBytes());
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] lpop(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            byte[] byArray = jedis.lpop(key.getBytes());
            return byArray;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByScore(String key, byte[] max, byte[] min) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrevrangeByScore(key.getBytes(), max, min);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByScore(String key, String max, String min) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrevrangeByScore(key.getBytes(), max.getBytes(), min.getBytes());
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<byte[]> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrevrangeByScore(key.getBytes(), max.getBytes(), min.getBytes(), offset, count);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long zcount(String key, String min, String max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long count = jedis.zcount(key.getBytes(), min.getBytes(), max.getBytes());
            long l = count == null ? 0L : count;
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByScore(String key, String start, String end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.zremrangeByScore(key.getBytes(), start.getBytes(), end.getBytes());
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zremrangeByRank(String key, long start, long end) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.zremrangeByRank(key.getBytes(), start, end);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zcount(String key, double min, double max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.zcount(key.getBytes(), min, max);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrangeByScore(key, min, max, offset, count);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrangeByScore(key, min, max);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> zrangeByScore(String key, long min, long max) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Set set = jedis.zrangeByScore(key, (double)min, (double)max);
            return set;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire(String key, int seconds) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            jedis.expire(key.getBytes(), seconds);
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireAt(String key, Long unixTime) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            jedis.expireAt(key.getBytes(), unixTime.longValue());
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> pipeHgetall(List<String> ids) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String id : ids) {
                jedisPipeline.hgetAll(id.getBytes());
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pipeZadd(String key, double score, List<String> members) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String member : members) {
                jedisPipeline.zadd(key.getBytes(), score, member.getBytes());
            }
            jedisPipeline.syncAndReturnAll();
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> pipeZcard(List<String> ids) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String id : ids) {
                jedisPipeline.zcard(id.getBytes());
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pipeHmset(String key, List<Map<byte[], byte[]>> hashs) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (Map<byte[], byte[]> hash : hashs) {
                jedisPipeline.hmset(key.getBytes(), hash);
            }
            jedisPipeline.syncAndReturnAll();
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrBy(String key, byte[] field, long value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.hincrBy(key.getBytes(), field, value);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            byte[] byArray = jedis.get(key.getBytes());
            return byArray;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            jedis.set(key.getBytes(), value);
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setex(String key, int seconds, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            jedis.setex(key.getBytes(), seconds, value);
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setnx(String key, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long r = jedis.setnx(key.getBytes(), value);
            boolean bl = r != null && r.intValue() == 1;
            return bl;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getTTL(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.ttl(key.getBytes());
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.incr(key.getBytes());
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long zrevrank(String key, byte[] member) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.zrevrank(key.getBytes(), member);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> pipeRpop(byte[] key, long size) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            int i = 0;
            while ((long)i < size) {
                jedisPipeline.rpop(key);
                ++i;
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long lrem(String key, long count, byte[] value) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            Long l = jedis.lrem(key.getBytes(), count, value);
            return l;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> pipeGet(List<String> keys) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            ShardedJedisPipeline jedisPipeline = jedis.pipelined();
            for (String key : keys) {
                jedisPipeline.get(key.getBytes());
            }
            List list = jedisPipeline.syncAndReturnAll();
            return list;
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pipeSet(Map<String, byte[]> keyValues, int seconds) {
        ShardedJedis jedis = null;
        try {
            jedis = this.shardedJedisPool.getResource();
            ShardedJedisPipeline pipeline = jedis.pipelined();
            Set<Map.Entry<String, byte[]>> entrySet = keyValues.entrySet();
            for (Map.Entry<String, byte[]> entry : entrySet) {
                pipeline.setex(entry.getKey().getBytes(), seconds, entry.getValue());
            }
            pipeline.sync();
        }
        finally {
            this.shardedJedisPool.returnResource(jedis);
        }
    }
}

