/*
 * Decompiled with CFR 0.152.
 */
package com.biz.redis.util;

import io.codis.jodis.RoundRobinJedisPool;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolConfig;

public class JodisRedisPoolLoad {
    private static final Logger log = LoggerFactory.getLogger(JodisRedisPoolLoad.class);
    private static RoundRobinJedisPool jodisPool;

    public static synchronized RoundRobinJedisPool jodisPool() {
        return jodisPool;
    }

    public static synchronized RoundRobinJedisPool getJodisPool(String localConfigPath) {
        if (jodisPool == null) {
            log.debug("\u5f00\u59cb\u521d\u59cb\u5316redis\u8fde\u63a5\u6c60\u5bf9\u8c61");
            PropertiesConfiguration config = null;
            try {
                config = new PropertiesConfiguration(localConfigPath);
            }
            catch (ConfigurationException e) {
                log.error("\u52a0\u8f7dredis\u914d\u7f6e\u51fa\u9519,-->", (Object)e.getMessage());
                e.printStackTrace();
            }
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(config.getInt("redis.maxTotal"));
            poolConfig.setMaxIdle(config.getInt("redis.maxIdle"));
            poolConfig.setTimeBetweenEvictionRunsMillis(config.getLong("redis.timeBetweenEvictionRunsMillis"));
            poolConfig.setMinEvictableIdleTimeMillis(config.getLong("redis.minEvictableIdleTimeMillis"));
            poolConfig.setTestOnBorrow(config.getBoolean("redis.testOnBorrow"));
            try {
                jodisPool = RoundRobinJedisPool.create().curatorClient(config.getString("redis.zookeeperUrl"), config.getInt("redis.zkSessionTimeout")).zkProxyDir(config.getString("redis.zkProxyDir")).poolConfig(poolConfig).database(config.getInt("redis.database")).build();
            }
            catch (Exception e) {
                log.error("jedisPool init failed!");
            }
            log.info("jedisPool init sucessful!");
        }
        return jodisPool;
    }
}

