/*
 * Decompiled with CFR 0.152.
 */
package com.biz.redis.util;

import com.biz.redis.bean.BaseRedisObject;
import com.biz.redis.util.ExpressionUtil;
import java.io.Serializable;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SortedSetAssist<T extends BaseRedisObject<ID>, ID extends Serializable> {
    private String fieldName;
    private String prefix;
    private Expression keyExpression;
    private Expression scoreExpression;

    public SortedSetAssist() {
    }

    public SortedSetAssist(String fieldName, String prefix, Expression keyExpression, Expression scoreExpression) {
        this.prefix = prefix;
        this.fieldName = fieldName;
        this.keyExpression = keyExpression;
        this.scoreExpression = scoreExpression;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public Expression getKeyExpression() {
        return this.keyExpression;
    }

    public void setKeyExpression(Expression keyExpression) {
        this.keyExpression = keyExpression;
    }

    public Expression getScoreExpression() {
        return this.scoreExpression;
    }

    public void setScoreExpression(Expression scoreExpression) {
        this.scoreExpression = scoreExpression;
    }

    public String getKey(T ro) {
        return this.prefix + ":" + ExpressionUtil.getKey(ro, this.keyExpression);
    }

    public long getScore(T ro) {
        return ExpressionUtil.getScore(new StandardEvaluationContext(ro), this.scoreExpression);
    }
}

