/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.act.project.controller;

import com.biz.eisp.act.entity.TtActDetailEntity;
import com.biz.eisp.act.project.service.ProjectDetailFindExcelDataExtend;
import com.biz.eisp.act.project.service.TtActProjectDetailImportCheckExtend;
import com.biz.eisp.act.project.service.TtActProjectDetailImportExtend;
import com.biz.eisp.base.ImpExpController;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.util.ExcelProgressUtil;
import com.biz.eisp.base.vo.ExcelDate;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.project.vo.ActProjectDetailImportVo;
import com.biz.eisp.service.RedisService;
import com.biz.eisp.tools.DictUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"ttActProjectDetailImportController"})
public class TtActProjectDetailImportController
extends ImpExpController {
    @Autowired
    private RedisService redisService;
    @Autowired(required=false)
    private TtActProjectDetailImportCheckExtend ttActProjectDetailImportCheckExtend;
    @Autowired(required=false)
    private TtActProjectDetailImportExtend ttActProjectDetailImportExtend;
    @Autowired(required=false)
    private ProjectDetailFindExcelDataExtend projectDetailFindExcelDataExtend;

    protected AjaxJson checkImportList(List importList, ExcelDate excelDate) {
        if (null != this.ttActProjectDetailImportCheckExtend) {
            return this.ttActProjectDetailImportCheckExtend.checkImportList(importList, excelDate);
        }
        return this.check(importList, excelDate);
    }

    private AjaxJson check(List<ActProjectDetailImportVo> importList, ExcelDate excelDate) {
        if (CollectionUtils.isEmpty(importList)) {
            ExcelProgressUtil.progress((boolean)true, (String)"\u6570\u636e\u4e3a\u7a7a", (String)excelDate.getExcelUuid(), null);
            AjaxJson json = new AjaxJson();
            json.setSuccess(false);
            return json;
        }
        List isNoList = DictUtil.getDictList((String)"pay_type");
        Map<String, String> dictMap = isNoList.stream().collect(Collectors.toMap(KnlDictDataEntity::getDictValue, KnlDictDataEntity::getDictCode));
        importList.stream().forEach(v -> v.setPayType((String)dictMap.get(v.getPayType())));
        return new AjaxJson();
    }

    protected AjaxJson doImportList(List importList, ExcelDate excelDate) {
        if (null != this.ttActProjectDetailImportExtend) {
            return this.ttActProjectDetailImportExtend.doImportList(importList, excelDate);
        }
        return this.importList(importList, excelDate);
    }

    private AjaxJson importList(List<ActProjectDetailImportVo> importList, ExcelDate excelDate) {
        int index = 2;
        ArrayList<TtActDetailEntity> ttActDetailEntityList = new ArrayList<TtActDetailEntity>();
        String tempId = excelDate.getStrExtend4();
        for (ActProjectDetailImportVo vo : importList) {
            try {
                TtActDetailEntity entity = new TtActDetailEntity();
                BeanUtils.copyProperties((Object)vo, (Object)entity);
                entity.setTempUuid(tempId);
                entity.setActCode(excelDate.getStrExtend2());
                entity.setActType(ConstantEnum.ACTTYPE.project.getVal());
                entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
                ttActDetailEntityList.add(entity);
                ++index;
            }
            catch (Exception e) {
                ExcelProgressUtil.progress((boolean)true, (String)("\u7b2c" + index + "\u884c\u5bfc\u5165\u5931\u8d25\uff1a" + e.getLocalizedMessage()), (String)excelDate.getExcelUuid(), null);
            }
        }
        this.saveDetailToRedis(tempId, ttActDetailEntityList);
        ExcelProgressUtil.progress((boolean)false, (String)("\u5bfc\u5165\u6210\u529f\u6761\u6570: " + (index - 2)), (String)excelDate.getExcelUuid(), null);
        return new AjaxJson();
    }

    public boolean saveDetailToRedis(String redisKey, List<TtActDetailEntity> redisValue) {
        return this.redisService.setMinutes(redisKey, redisValue, 30L);
    }

    @PostMapping(value={"findExcelDetail"})
    @ResponseBody
    public AjaxJson findExcelDetail(String tempId) {
        AjaxJson ajaxJson = new AjaxJson();
        List list = this.projectDetailFindExcelDataExtend != null ? this.projectDetailFindExcelDataExtend.findExcelDetail(tempId) : (List)this.redisService.get(tempId);
        if (null == list) {
            ajaxJson.setSuccess(false);
            ajaxJson.setErrMsg("\u5bfc\u5165\u5931\u8d25\uff01");
            return ajaxJson;
        }
        ajaxJson.setList(list);
        return ajaxJson;
    }
}

