<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@include file="/context/mytags.jsp" %>
<t:base type="jquery,easyui,tools,DatePicker"></t:base>
<div id="system_role_roleList" class="easyui-layout" fit="true">
    <div region="center" style="padding: 1px;">
        <t:datagrid name="roleList" title="工作流角色" actionUrl="findActRoleList?1=1"
                    idField="id" fit="true" fitColumns="false" queryMode="group">
            <t:dgCol title="主键" field="id" hidden="true"/>
            <t:dgCol title="角色编码" field="roleCode" width="120" query="true"/>
            <t:dgCol title="角色名称" field="roleName" width="120" query="true"/>
            <t:dgToolBar title="新增"  icon="icon-add"
                         url="goTaActivitiRoleForm" funname="addRole"/>
            <t:dgToolBar title="编辑"  icon="icon-edit"
                         url="goTaActivitiRoleForm" funname="updateRole"/>
            <t:dgToolBar title="删除"  icon="icon-remove"
                         url="deleteTaActivitiRoleById" funname="deleteById"/>
            <t:dgToolBar title="查看职位"  icon="icon-preview" url=""
                         funname="findTmPositionByRole"/>
            <t:dgToolBar title="查看流程"  icon="icon-preview" url=""
                         funname="findProcessInstance"/>
            <t:dgToolBar title="角色-职位关系导入"  icon="icon-dataIn"
                         onclick="importDataByXml({impName:'tmActRolePositionRel', gridName:'actRoleSelectList'})"/>
            <%--<t:dgToolBar title="日志"  icon="icon-log" url="tmLogController.do?goTmLogDetailMain"--%>
                         <%--funname="detailLog" width="1200" height="460"/>--%>
        </t:datagrid>
    </div>
    <div data-options="region:'east',
	title:'权限列表',
	collapsed:true,
	split:true,
	border:false,
	onExpand : function(){
		li_east = 1;
	},
	onCollapse : function() {
	    li_east = 0;
	}"
         style="width: 500px; overflow: hidden;">
        <div class="easyui-panel" style="padding: 1px;" fit="true" border="false" id="PermissonDeatil"></div>
    </div>
</div>

<script type="text/javascript">
    $(function () {
        var li_east = 0;
    });

    //删除
    function deleteById() {
        var roleTarget = $("#roleList").datagrid('getSelected');
        if (roleTarget == null) {
            tip("请至少选择一条数据");
            return;
        }
        $.messager.confirm('操作提示', "确定删除数据吗?", function (r) {
            if (r) {
                $.ajax({
                    type: "POST",
                    url: "${activitiRoot}taActivitiRoleController/deleteTaActivitiRoleById",
                    data: {
                        "id": roleTarget.id,
                    },
                    dataType: "json",
                    success: function (data) {
                        tip(data.msg);
                        $("#roleList").datagrid('reload');
                    },
                    error: function () {
                        tip("服务器异常，请稍后再试");
                    }
                });
            }
        });
    }

    function addRole(title, url, id) {
        add(title, url, 'roleList');
    }

    function updateRole(title, url, id) {
        var rowData = $('#' + id).datagrid('getSelected');
        if (rowData) {
            url += '&id=' + rowData.id;
        }
        add(title, url, 'roleList');
    }

    //查询职位
    function findTmPositionByRole() {
        var rowData = $("#roleList").datagrid('getSelected');
        if (rowData == "" || rowData == null) {
            tip("请选择一条角色数据");
            return false;
        }
        var roleCode = rowData.roleCode;
        openwindow("相关职位", "${activitiRoot}taActivitiRoleController/goTmPositionByRoleMain?roleCode=" + roleCode, "tmPositionByRole", 1000, 500);
    }

    //查看流程
    function findProcessInstance() {
        var rowData = $("#roleList").datagrid('getSelected');
        if (rowData == "" || rowData == null) {
            tip("请选择一条角色数据");
            return false;
        }
        var roleId = rowData.id;
        openwindow("查看流程", "${activitiRoot}taActivitiRoleController/goTaProcessDefinitionMain?id=" + roleId, "taProcessDefinition", 1000, 500);
    }
</script>

