/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.businessconf.controller;

import com.biz.eisp.activiti.designer.businessconf.entity.TaBusinessObjEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaBusinessObjService;
import com.biz.eisp.activiti.designer.businessconf.vo.TaBusinessObjVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"taBusinessObjController"})
public class TaBusinessObjController {
    @Autowired
    private TaBusinessObjService taBusinessObjService;

    @RequestMapping(value={"goTaBusinessObjMain"})
    public ModelAndView goTaBusinessObjMain() {
        return new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taBusinessObjMain");
    }

    @RequestMapping(value={"goTaBusinessObjForm"})
    public ModelAndView goTaBusinessObjForm(String busId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taBusinessObjForm");
        if (StringUtils.isNotBlank((CharSequence)busId)) {
            TaBusinessObjVo vo = this.taBusinessObjService.getBusinessObjById(busId);
            view.addObject("busVo", (Object)vo);
        }
        return view;
    }

    @RequestMapping(value={"findTaBusinessObjList"})
    @ResponseBody
    public DataGrid findTaBusinessObjList(HttpServletRequest request) {
        List<TaBusinessObjEntity> list = this.taBusinessObjService.findAllBusinessObj();
        return new DataGrid(list, null);
    }

    @RequestMapping(value={"saveOrUpdateTaBusinessObj"})
    @ResponseBody
    public AjaxJson saveOrUpdateTaBusinessObj(TaBusinessObjVo vo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taBusinessObjService.saveOrUpdateBusinessObj(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setMsg(e.getMessage());
            aj.setSuccess(false);
        }
        return aj;
    }

    @RequestMapping(value={"delTaBusinessObjById"})
    @ResponseBody
    public AjaxJson delTaBusinessObjById(String busId) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taBusinessObjService.deleteBusinessObj(busId);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setMsg(e.getMessage());
            aj.setSuccess(false);
        }
        return aj;
    }

    @GetMapping(value={"getBusinessObjById"})
    @ResponseBody
    public AjaxJson<TaBusinessObjVo> getBusinessObjById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TaBusinessObjVo vo = this.taBusinessObjService.getBusinessObjById(id);
        ajaxJson.setObj((Object)vo);
        return ajaxJson;
    }

    @GetMapping(value={"findAllBusinessObj"})
    @ResponseBody
    public AjaxJson<TaBusinessObjEntity> findAllBusinessObj() {
        AjaxJson ajaxJson = new AjaxJson();
        List<TaBusinessObjEntity> taBusinessObjVos = this.taBusinessObjService.findAllBusinessObj();
        ajaxJson.setList(taBusinessObjVos);
        return ajaxJson;
    }
}

