/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processcheck.controller;

import com.biz.eisp.activiti.designer.processcheck.batchck.BatchCheckProDeal;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckDetail;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckRecord;
import com.biz.eisp.activiti.designer.processcheck.service.TaProcessCheckService;
import com.biz.eisp.activiti.designer.processcheck.vo.ProcCkQuerySetVo;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.activiti.util.EhcacheUtil;
import com.biz.eisp.activiti.util.JsonUtil;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"taProcessCheckApiController"})
public class TaProcessCheckApiController {
    @Autowired
    private TaProcessCheckService taProcessCheckService;
    @Autowired
    private TaskService taskService;

    @RequestMapping(value={"createProcessCheckJson"})
    @ResponseBody
    public AjaxJson<String> createProcessCheckJson(@RequestParam(value="processKey") String processKey) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            TaProcessCkRecordVo taProcessCkRecordVo = this.taProcessCheckService.createProcessCheck(processKey);
            ajaxJson.setObj((Object)JsonUtil.toJson(taProcessCkRecordVo));
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"checkQuerySetJson"})
    @ResponseBody
    public AjaxJson<String> checkQuerySetJson(@RequestParam(value="processId") String processId) {
        AjaxJson ajaxJson = new AjaxJson();
        List<ProcCkQuerySetVo> list = this.taProcessCheckService.checkQuerySet(processId);
        try {
            ajaxJson.setObj((Object)JsonUtil.toJson(list));
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"saveRecord"})
    @ResponseBody
    public AjaxJson<String> saveRecord(@RequestParam(value="processId") String processId, @RequestParam(value="proCkQuerySet") String proCkQuerySet) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            ajaxJson.setObj((Object)this.taProcessCheckService.saveRecord(processId, proCkQuerySet));
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"updateCkRecord"})
    @ResponseBody
    public AjaxJson updateCkRecord(@RequestBody TaProcessCheckRecord entity) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.taProcessCheckService.updateCkRecord(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"saveStopedNode"})
    @ResponseBody
    public AjaxJson<TaProcessCheckDetail> saveStopedNode(@RequestParam(value="isStopCheck") String isStopCheck, @RequestParam(value="nodeCode") String nodeCode, @RequestParam(value="recordId") String recordId, @RequestParam(value="allCkState") String allCkState) {
        AjaxJson aj = new AjaxJson();
        aj.setMsg("\u4fdd\u5b58\u4e2d\u65ad\u8282\u70b9\u8bb0\u5f55\u6210\u529f");
        aj.setSuccess(true);
        TaProcessCheckDetail detail = this.taProcessCheckService.findCheckDetail(nodeCode, recordId);
        try {
            detail.setCheckTime(DateUtils.getFormatDateStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            detail.setState("3");
            String remark = "<p><span style=\"color: blue;\">\u8282\u70b9\u68c0\u6d4b\u4e2d\u65ad";
            remark = "true".equals(isStopCheck) ? remark + "\uff0c\u539f\u56e0\uff1a\u4e2d\u9014\u505c\u6b62\u68c0\u6d4b\uff0c\u88ab\u8feb\u4e2d\u65ad\uff01" : ("1".equals(allCkState) ? remark + "\uff0c\u539f\u56e0\uff1a\u672a\u81ea\u52a8\u627e\u5230\u8be5\u8282\u70b9\u4efb\u52a1\uff0c\u53ef\u80fd\u8be5\u8282\u70b9\u4e3a\u6761\u4ef6\u53c2\u6570\u7684\u5206\u652f\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5206\u652f\u53c2\u6570\u518d\u68c0\u6d4b\uff01" : remark + "\uff0c\u539f\u56e0\uff1a\u4e2d\u9014\u8282\u70b9\u68c0\u6d4b\u5931\u8d25\uff0c\u88ab\u8feb\u4e2d\u65ad\uff01");
            remark = remark + "</span></p><p>-----------------------------------------</p>";
            detail.setCheckResult(remark);
            this.taProcessCheckService.updateEntity(detail);
            aj.setObj((Object)detail);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u4fdd\u5b58\u4e2d\u65ad\u8282\u70b9\u8bb0\u5f55\u5931\u8d25");
        }
        return aj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"passCkReq"})
    @ResponseBody
    public AjaxJson<TaProcessCheckDetail> passCkReq(@RequestParam(value="nodeCode") String nodeCode, @RequestParam(value="recordId") String recordId) {
        AjaxJson aj = new AjaxJson();
        aj.setMsg("\u68c0\u6d4b\u8bb0\u5f55\u6210\u529f");
        aj.setSuccess(true);
        TaProcessCheckDetail detail = this.taProcessCheckService.findCheckDetail(nodeCode, recordId);
        try {
            detail = this.taProcessCheckService.passCkReq(detail);
            String procInsId = detail.getProcessInsId();
            List nextTasks = this.taskService.createTaskQuery().processInstanceId(procInsId).list();
            if (nextTasks.size() > 0) {
                detail.setNextNode(((Task)nextTasks.get(0)).getTaskDefinitionKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        finally {
            this.taProcessCheckService.updateEntity(detail);
            aj.setObj((Object)detail);
            return aj;
        }
    }

    @RequestMapping(value={"loadHisRecord"})
    @ResponseBody
    public AjaxJson<TaProcessCkRecordVo> loadHisRecord(@RequestParam(value="processId") String processId) {
        AjaxJson ajaxJson = new AjaxJson();
        TaProcessCkRecordVo vo = new TaProcessCkRecordVo();
        vo.setProcessId(processId);
        vo.setState("1");
        List<TaProcessCkRecordVo> list = this.taProcessCheckService.getCkRecords(vo);
        vo.setState("2");
        if (CollectionUtil.listEmpty(list)) {
            list = new ArrayList<TaProcessCkRecordVo>();
        }
        list.addAll(this.taProcessCheckService.getCkRecords(vo));
        ajaxJson.setObjList(list);
        return ajaxJson;
    }

    @RequestMapping(value={"deleteHis"})
    @ResponseBody
    public AjaxJson deleteHis(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.taProcessCheckService.deleteHis(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setSuccess(false);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"findRecordDetail"})
    @ResponseBody
    public AjaxJson<TaProcessCkRecordVo> findRecordDetail(@RequestParam(value="recordId") String recordId) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            TaProcessCkRecordVo vo = this.taProcessCheckService.findRecordDetail(recordId);
            ajaxJson.setObj((Object)vo);
            HashMap<String, String> att = new HashMap<String, String>();
            att.put("voJson", JsonUtil.toJson(vo));
            ajaxJson.setAttributes(att);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(value={"toBatchCheck"})
    @ResponseBody
    public AjaxJson toBatchCheck(@RequestParam(value="processId") String processId, @RequestParam(value="proCkQuerySet") String proCkQuerySet) {
        AjaxJson aj = new AjaxJson();
        aj.setMsg("\u6279\u91cf\u68c0\u6d4b\u5f00\u59cb\u6210\u529f");
        aj.setSuccess(true);
        try {
            String batchId = UUID.randomUUID().toString().replace("-", "");
            TaProcessCkRecordVo vo = (TaProcessCkRecordVo)EhcacheUtil.getItem("PRO_CK_" + processId);
            vo.setId(batchId);
            vo.setTitle(vo.getTitle());
            vo.setCkParams(proCkQuerySet);
            vo.setIsBatchUser(Integer.valueOf(1));
            vo.setCheckTime(DateUtils.getFormatDateStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            String modelDetails = JsonUtil.toJson(vo.getCkPassDetails());
            vo.setCkPassDetails(new ArrayList());
            List<String> users = this.taProcessCheckService.getBatchUserIds(proCkQuerySet);
            vo.setUsers(users);
            for (String user : users) {
                ArrayList<TaProcessCheckDetail> details = JsonUtil.toObjectArrayListFromJson(modelDetails, new TypeReference<List<TaProcessCheckDetail>>(){});
                for (TaProcessCheckDetail detail : details) {
                    detail.setUserName(user);
                }
                vo.getCkPassDetails().addAll(details);
            }
            EhcacheUtil.putItem("PRO_CK_" + batchId, vo);
            EhcacheUtil.putItem("PRO_CK_PG_ALL_" + batchId, vo.getCkPassDetails().size());
            EhcacheUtil.putItem("PRO_CK_PG_SUCC_" + batchId, 0);
            EhcacheUtil.putItem("PRO_CK_PG_FAIL_" + batchId, 0);
            EhcacheUtil.putItem("PRO_CK_PG_STOP_" + batchId, 0);
            new BatchCheckProDeal(users, batchId).execute();
            aj.setObj((Object)batchId);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u6279\u91cf\u68c0\u6d4b\u5f02\u5e38");
        }
        return aj;
    }

    @RequestMapping(value={"batchProgress"})
    @ResponseBody
    public AjaxJson batchProgress(@RequestParam(value="batchId") String batchId) {
        AjaxJson aj = new AjaxJson();
        aj.setMsg("\u6279\u91cf\u68c0\u6d4b\u8fdb\u5ea6\u60c5\u51b5\u83b7\u53d6\u6210\u529f");
        aj.setSuccess(true);
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int succ = (Integer)EhcacheUtil.getItem("PRO_CK_PG_SUCC_" + batchId);
            int fail = (Integer)EhcacheUtil.getItem("PRO_CK_PG_FAIL_" + batchId);
            int stop = (Integer)EhcacheUtil.getItem("PRO_CK_PG_STOP_" + batchId);
            int count = (Integer)EhcacheUtil.getItem("PRO_CK_PG_ALL_" + batchId);
            int pg = (succ + fail + stop) * 100 / count;
            if (pg == 100) {
                TaProcessCkRecordVo vo = (TaProcessCkRecordVo)EhcacheUtil.getItem("PRO_CK_" + batchId);
                List ckDetails = vo.getCkPassDetails();
                for (String user : vo.getUsers()) {
                    for (TaProcessCheckDetail detail : ckDetails) {
                        if (!user.equals(detail.getUserName())) continue;
                    }
                }
            }
            map.put("succ", succ);
            map.put("fail", fail);
            map.put("stop", stop);
            map.put("pg", pg);
            aj.setAttributes(map);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u6279\u91cf\u68c0\u6d4b\u8fdb\u5ea6\u60c5\u51b5\u83b7\u53d6\u5f02\u5e38");
        }
        return aj;
    }

    @RequestMapping(value={"saveBatchCk"})
    @ResponseBody
    public AjaxJson saveBatchCk(@RequestParam(value="batchId") String batchId, @RequestParam(value="resultRemark") String resultRemark) {
        AjaxJson aj = new AjaxJson();
        aj.setMsg("\u751f\u6210\u62a5\u544a\u6210\u529f");
        aj.setSuccess(true);
        try {
            this.taProcessCheckService.saveBatchCk(batchId, resultRemark);
            EhcacheUtil.removeItem("PRO_CK_" + batchId);
            EhcacheUtil.removeItem("PRO_CK_PG_ALL_" + batchId);
            EhcacheUtil.removeItem("PRO_CK_PG_SUCC_" + batchId);
            EhcacheUtil.removeItem("PRO_CK_PG_FAIL_" + batchId);
            EhcacheUtil.removeItem("PRO_CK_PG_STOP_" + batchId);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg("\u751f\u6210\u62a5\u544a\u5931\u8d25");
        }
        return aj;
    }
}

