/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.api.feign.RoleActivitiFeign;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.role.TmActRoleVo;
import com.biz.eisp.user.TmUserVo;
import com.biz.eisp.util.ResourceService;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"taActivitiRoleController"})
public class TaActivitiRoleController {
    @Autowired
    private RoleActivitiFeign roleActivitiFeign;
    @Autowired
    private ResourceService resource;

    @RequestMapping(value={"goTaActivitiRoleMain"})
    public ModelAndView goTaActivitiRoleMain() {
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiRoleMain");
    }

    @RequestMapping(value={"goTaActivitiRoleForm"})
    public ModelAndView goTaActivitiRoleForm(String id) {
        ModelAndView mv = new ModelAndView("com/biz/eisp/activiti/designer/processconf/taActivitiRoleForm");
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            TmActRoleVo roleVo = (TmActRoleVo)ApiResultUtil.objResult((AjaxJson)this.roleActivitiFeign.getTmActRoleById(id));
            mv.addObject("role", (Object)roleVo);
        } else {
            TmActRoleVo roleEntity = new TmActRoleVo();
            roleEntity.setRoleCode("BPM_");
            mv.addObject("role", (Object)roleEntity);
        }
        return mv;
    }

    @RequestMapping(value={"findActRoleList"})
    @ResponseBody
    public DataGrid findActRoleList(TmActRoleVo tmActRoleVo, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("page", page.getPage());
        param.put("rows", page.getRows());
        param.put("roleCode", tmActRoleVo.getRoleCode());
        param.put("roleName", tmActRoleVo.getRoleName());
        PageInfo pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.roleActivitiFeign.findRoleByCondition(param));
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"findTaActivitiRoleList"})
    @ResponseBody
    public DataGrid findTpUserList(TmActRoleVo tmActRoleVo, HttpServletRequest request) {
        String posId = this.resource.getCurrPosition().getId();
        TmUserVo tmUserVo = this.resource.getUserVo();
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((Object)tmUserVo) && Globals.Admin_Name.equalsIgnoreCase(tmUserVo.getUsername())) {
            tmActRoleVo.setPosId(null);
        } else {
            tmActRoleVo.setPosId(posId);
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("page", page.getPage());
        param.put("rows", page.getRows());
        param.put("posId", posId);
        PageInfo pageInfo = ApiResultUtil.pageInfoResult((AjaxJson)this.roleActivitiFeign.findRoleByPositionId(param));
        return new DataGrid(pageInfo);
    }
}

