/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taProcessNodeController"})
public class TaProcessNodeController {
    @Autowired
    private TaProcessNodeService taProcessNodeService;

    @RequestMapping(value={"findNodeBypdKey"})
    public DataGrid findNodeBypdKey(String taProcessId) {
        List<TaProcessNodeVo> list = this.taProcessNodeService.getNodeByProcessId(taProcessId);
        return new DataGrid(list, null);
    }

    @RequestMapping(value={"saveOrUpdateTaProcessNode"})
    public AjaxJson saveOrUpdateTaProcessNode(TaProcessNodeVo nodeVo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessNodeService.saveProcessNode(nodeVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"deleteTaProcessodeById"})
    public AjaxJson deleteTaProcessNodeById(String id) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessNodeService.deleteProcessNodeById(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"validateNode"})
    public ValidForm validateNode(TaProcessNodeVo nodeVo, String param) {
        ValidForm vf = new ValidForm();
        try {
            if ("1".equals(nodeVo.getFlag())) {
                nodeVo.setProcessNodeCode(param);
            }
            if ("0".equals(nodeVo.getFlag())) {
                nodeVo.setProcessNodeName(param);
            }
            this.taProcessNodeService.validateNode(nodeVo);
        }
        catch (Exception e) {
            vf.setStatus("n");
            vf.setInfo(e.getMessage());
        }
        return vf;
    }

    @GetMapping(value={"getNodeByProcessId"})
    public AjaxJson<TaProcessNodeVo> getNodeByProcessId(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TaProcessNodeVo> nodes = this.taProcessNodeService.getNodeByProcessId(id);
        ajaxJson.setList(nodes);
        return ajaxJson;
    }

    @GetMapping(value={"getNodeById"})
    AjaxJson<TaProcessNodeVo> getNodeById(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TaProcessNodeVo vo = this.taProcessNodeService.getNodeById(id);
        ajaxJson.setObj((Object)vo);
        return ajaxJson;
    }
}

