/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.service.impl;

import com.biz.eisp.activiti.designer.processconf.dao.TaProcessFunctionAuthDao;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessFunctionAuthEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessFunctionAuthService;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessFunctionAuthEntityToTaProcessFunctionAuthVo;
import com.biz.eisp.activiti.designer.processconf.transformer.TaProcessFunctionAuthVoToTaProcessFunctionAuthEntity;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessFunctionAuthVo;
import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taProcessFunctionAuthService")
@Transactional
public class TaProcessFunctionAuthServiceImpl
implements TaProcessFunctionAuthService {
    @Autowired
    private TaProcessFunctionAuthDao taProcessFunctionAuthDao;
    @Autowired
    private TmOrgFeign tmOrgFeign;

    @Override
    public PageInfo<TaProcessFunctionAuthVo> findTaProcessFunctionAuthVoList(TaProcessFunctionAuthVo vo, Page page) {
        Example example = new Example(TaProcessFunctionAuthEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)vo.getFunctionName())) {
            criteria.andLike("functionName", "%" + vo.getFunctionName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getOrgCode())) {
            criteria.andLike("orgCode", "%" + vo.getOrgCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getOrgName())) {
            criteria.andLike("orgName", "%" + vo.getOrgName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getProcessCode())) {
            criteria.andLike("processCode", "%" + vo.getProcessCode() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getProcessName())) {
            criteria.andLike("processName", "%" + vo.getProcessName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getCreateName())) {
            criteria.andLike("createName", "%" + vo.getCreateName() + "%");
        }
        if (StringUtil.isNotEmpty((CharSequence)vo.getUpdateName())) {
            criteria.andLike("updateName", "%" + vo.getUpdateName() + "%");
        }
        PageInfo list = PageAutoHelperUtil.generatePage(() -> this.taProcessFunctionAuthDao.selectByExample(example), (Page)page);
        return list;
    }

    @Override
    public void saveTaProcessFunctionAuth(TaProcessFunctionAuthVo vo) {
        TaProcessFunctionAuthEntity entity = new TaProcessFunctionAuthVoToTaProcessFunctionAuthEntity().apply(vo);
        if (StringUtil.isEmpty((String)entity.getId())) {
            this.taProcessFunctionAuthDao.insertSelective(entity);
        } else {
            this.taProcessFunctionAuthDao.updateByPrimaryKeySelective(entity);
        }
    }

    @Override
    public void deleteTaProcessFunctionAuthVo(String id) {
        this.taProcessFunctionAuthDao.deleteByPrimaryKey(id);
    }

    @Override
    public TaProcessFunctionAuthVo getTaProcessFunctionAuthVo(String id) {
        TaProcessFunctionAuthEntity entity = (TaProcessFunctionAuthEntity)this.taProcessFunctionAuthDao.selectByPrimaryKey(id);
        return new TaProcessFunctionAuthEntityToTaProcessFunctionAuthVo().apply(entity);
    }

    @Override
    public List<TaProcessFunctionAuthVo> findTaProcessListByFunctionId(String functionId) {
        String posId = UserUtils.getUser().getPosId();
        AjaxJson ajaxJson = this.tmOrgFeign.getOrgByPos(posId, null);
        TmOrgVo tmOrgVo = (TmOrgVo)ajaxJson.getObj();
        List orgVos = this.tmOrgFeign.getOrgList(tmOrgVo.getId(), null).getObjList();
        return this.taProcessFunctionAuthDao.findTaProcessListByFunctionId(functionId, orgVos);
    }

    @Override
    public List<TaProcessFunctionAuthVo> findTaProcessListByFunctionIdAndOrgCode(String functionId, String orgCode) {
        if (StringUtil.isBlank((CharSequence)orgCode)) {
            return this.findTaProcessListByFunctionId(functionId);
        }
        List orgVos = this.tmOrgFeign.getOrgList(null, orgCode).getObjList();
        return this.taProcessFunctionAuthDao.findTaProcessListByFunctionId(functionId, orgVos);
    }
}

