/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.hideNode.service.impl;

import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.activiti.hideNode.dao.TaHideNodeDao;
import com.biz.eisp.activiti.hideNode.entity.TaHideNodeEntity;
import com.biz.eisp.activiti.hideNode.service.TaHideNodeService;
import com.biz.eisp.activiti.hideNode.vo.TaHideNodeVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="taHideNodeService")
@Transactional
public class TaHideNodeServiceImpl
implements TaHideNodeService {
    @Autowired
    private TaHideNodeDao taHideNodeDao;
    @Autowired
    private TaskService taskService;

    @Override
    public AjaxJson<TaHideNodeVo> findHideNodeList(TaHideNodeVo vo, Page page) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        this.validateNotNull(processInstanceId, taskId);
        String nodeCode = this.getNodeCode(taskId);
        vo.setHiddenNodeCode(nodeCode);
        PageInfo voList = PageAutoHelperUtil.generatePage(() -> this.taHideNodeDao.findHideNodeList(vo), (Page)page);
        AjaxJson result = new AjaxJson();
        result.setList(voList.getList());
        result.setTotal(voList.getTotal());
        return result;
    }

    @Override
    public AjaxJson<TaHideNodeVo> findHidedNodeList(TaHideNodeVo vo, Page page) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        this.validateNotNull(processInstanceId, taskId);
        String taskDefinitionKey = this.getNodeCode(taskId);
        vo.setHiddenNodeCode(taskDefinitionKey);
        PageInfo voList = PageAutoHelperUtil.generatePage(() -> this.taHideNodeDao.findHidedNodeList(vo), (Page)page);
        AjaxJson result = new AjaxJson();
        result.setList(voList.getList());
        result.setTotal(voList.getTotal());
        return result;
    }

    @Override
    public void saveHideNode(TaHideNodeVo vo) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        String toHiddenNodeCodes = vo.getToHiddenNodeCodes();
        String toHiddenNodeNames = vo.getToHiddenNodeNames();
        String isCopyCir = vo.getIsCopyCir();
        String isCommunicate = vo.getIsCommunicate();
        this.validateNotNull(processInstanceId, taskId, isCopyCir);
        String nodeCode = this.getNodeCode(taskId);
        Example example = new Example(TaHideNodeEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processInstanceId", (Object)processInstanceId);
        criteria.andEqualTo("hiddenNodeCode", (Object)nodeCode);
        this.taHideNodeDao.deleteByExample(example);
        String[] nodes = toHiddenNodeCodes.split(",");
        String[] names = toHiddenNodeNames.split(",");
        if (nodes.length == 0) {
            TaHideNodeEntity entity = new TaHideNodeEntity();
            entity.setProcessInstanceId(processInstanceId);
            entity.setHiddenNodeCode(nodeCode);
            entity.setHiddenNodeName(this.getNodeName(nodeCode, processInstanceId));
            entity.setIsCopyCir(isCopyCir);
            entity.setIsCommunicate(isCommunicate);
            this.taHideNodeDao.insertSelective((Object)entity);
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                TaHideNodeEntity entity = new TaHideNodeEntity();
                entity.setProcessInstanceId(processInstanceId);
                entity.setHiddenNodeCode(nodeCode);
                entity.setHiddenNodeName(this.getNodeName(nodeCode, processInstanceId));
                entity.setToHiddenNodeCode(nodes[i]);
                entity.setToHiddenNodeName(names[i]);
                entity.setIsCopyCir(isCopyCir);
                entity.setIsCommunicate(isCommunicate);
                this.taHideNodeDao.insertSelective((Object)entity);
            }
        }
    }

    @Override
    public void deleHideNode(TaHideNodeVo vo) {
        String processInstanceId = vo.getProcessInstanceId();
        String hiddenNodeCode = vo.getHiddenNodeCode();
        String toHiddenNodeCodes = vo.getToHiddenNodeCodes();
        this.validateNotNull(processInstanceId, hiddenNodeCode, toHiddenNodeCodes);
        List<String> toHiddenNodeCodeList = Arrays.asList(toHiddenNodeCodes.split(","));
        Example example = new Example(TaHideNodeEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processInstanceId", (Object)processInstanceId);
        criteria.andEqualTo("hiddenNodeCode", (Object)hiddenNodeCode);
        criteria.andIn("toHiddenNodeCode", toHiddenNodeCodeList);
        this.taHideNodeDao.deleteByExample(example);
    }

    @Override
    public List<TaProcessNodeVo> findOpenNode(String processInstanceId, String processNodeCode) {
        TaHideNodeEntity record = new TaHideNodeEntity();
        record.setProcessInstanceId(processInstanceId);
        record.setToHiddenNodeCode(processNodeCode);
        List entityList = this.taHideNodeDao.select((Object)record);
        ArrayList<TaProcessNodeVo> processNodeVoList = new ArrayList<TaProcessNodeVo>();
        for (TaHideNodeEntity hideNodeEntity : entityList) {
            TaProcessNodeVo processNodeVo = new TaProcessNodeVo();
            processNodeVo.setProcessNodeCode(hideNodeEntity.getHiddenNodeCode());
            processNodeVo.setProcessNodeName(hideNodeEntity.getHiddenNodeName());
            processNodeVoList.add(processNodeVo);
        }
        return processNodeVoList;
    }

    @Override
    public AjaxJson<TaHideNodeEntity> getInitAttribute(TaHideNodeVo vo) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        String nodeCode = this.getNodeCode(taskId);
        TaHideNodeEntity record = new TaHideNodeEntity();
        record.setProcessInstanceId(processInstanceId);
        record.setHiddenNodeCode(nodeCode);
        AjaxJson result = new AjaxJson();
        result.setData(this.taHideNodeDao.selectOne((Object)record));
        return result;
    }

    @Override
    public void initAllNodeToHide(TaHideNodeVo vo) {
        List hideNodeList = this.findHideNodeList(vo, null).getObjList();
        String codes = "";
        String names = "";
        for (TaHideNodeVo taHideNodeVo : hideNodeList) {
            String processNodeCode = taHideNodeVo.getProcessNodeCode();
            String processNodeName = taHideNodeVo.getProcessNodeName();
            codes = codes + processNodeCode + ",";
            names = names + processNodeName + ",";
        }
        if (StringUtils.isNotBlank((CharSequence)codes)) {
            vo.setToHiddenNodeCodes(codes);
            vo.setToHiddenNodeNames(names);
            this.saveHideNode(vo);
        }
    }

    @Override
    public void delAllNodeToHide(TaHideNodeVo vo) {
        String processInstanceId = vo.getProcessInstanceId();
        String taskId = vo.getTaskId();
        this.validateNotNull(processInstanceId, taskId);
        String nodeCode = this.getNodeCode(taskId);
        Example example = new Example(TaHideNodeEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("processInstanceId", (Object)processInstanceId);
        criteria.andEqualTo("hiddenNodeCode", (Object)nodeCode);
        this.taHideNodeDao.deleteByExample(example);
    }

    private String getNodeName(String nodeCode, String processInstanceId) {
        TaHideNodeVo vo = new TaHideNodeVo();
        vo.setProcessInstanceId(processInstanceId);
        vo.setProcessNodeCode(nodeCode);
        List<TaHideNodeVo> list = this.taHideNodeDao.getNodeName(vo);
        if (!CollectionUtil.listNotEmptyNotSizeZero(list)) {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u6d41\u7a0b\u8282\u70b9");
        }
        String processNodeName = list.get(0).getProcessNodeName();
        return processNodeName;
    }

    private String getNodeCode(String taskId) {
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        return taskDefinitionKey;
    }

    private void validateNotNull(String ... strs) {
        for (String str : strs) {
            if (!StringUtils.isBlank((CharSequence)str)) continue;
            throw new BusinessException("\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5");
        }
    }
}

