/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.service.impl;

import com.biz.eisp.activiti.service.ReceiveMdmService;
import com.biz.eisp.activiti.vo.GroupActivitiVo;
import com.biz.eisp.activiti.vo.MembershipActivitiVo;
import com.biz.eisp.activiti.vo.UserActivitiVo;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.identity.Group;
import org.activiti.engine.identity.User;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReceiveMdmServiceImpl
implements ReceiveMdmService {
    @Override
    public void saveUser(UserActivitiVo userActivitiVo) {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        if (StringUtils.isBlank((CharSequence)userActivitiVo.getPosCode())) {
            return;
        }
        User user = (User)identityService.createUserQuery().userId(userActivitiVo.getPosCode()).singleResult();
        if (user != null) {
            user.setFirstName(userActivitiVo.getPosName());
            identityService.saveUser(user);
        } else {
            user = identityService.newUser(userActivitiVo.getPosCode());
            user.setFirstName(userActivitiVo.getPosName());
            identityService.saveUser(user);
        }
    }

    @Override
    public void saveGroup(GroupActivitiVo groupActivitiVo) {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        if (StringUtils.isBlank((CharSequence)groupActivitiVo.getType())) {
            return;
        }
        Group group = (Group)identityService.createGroupQuery().groupId(groupActivitiVo.getType()).singleResult();
        if (group != null) {
            group.setName(groupActivitiVo.getName());
            identityService.saveGroup(group);
        } else {
            group = identityService.newGroup(groupActivitiVo.getType());
            group.setName(groupActivitiVo.getName());
            group.setType(groupActivitiVo.getType());
            identityService.saveGroup(group);
        }
    }

    @Override
    public void saveMembership(MembershipActivitiVo membershipActivitiVo) {
        ProcessEngine engine = ProcessEngines.getDefaultProcessEngine();
        IdentityService identityService = engine.getIdentityService();
        identityService.deleteMembership(membershipActivitiVo.getPosCode(), membershipActivitiVo.getRoleCode());
        identityService.createMembership(membershipActivitiVo.getPosCode(), membershipActivitiVo.getRoleCode());
    }
}

