/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.util;

import com.biz.eisp.api.feign.TmOrgFeign;
import com.biz.eisp.api.feign.TmPositionFeign;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.org.TmOrgVo;
import com.biz.eisp.position.TmPositionVo;
import com.biz.eisp.user.TmUserVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ResourceService {
    @Autowired
    private TmPositionFeign tmPositionFeign;
    @Autowired
    private TmOrgFeign tmOrgFeign;

    public String getCreateName() {
        TmUserVo user = this.getUserVo();
        TmPositionVo position = this.getCurrPosition();
        if (user == null || position == null) {
            return null;
        }
        return user.getFullname() + "(" + position.getPositionName() + ")";
    }

    public TmUserVo getUserVo() {
        TmUserVo userVo = new TmUserVo();
        UserRedis user = UserUtils.getUser();
        userVo.setUsername(user.getUsername());
        userVo.setFullname(user.getRealname());
        return userVo;
    }

    public List<TmPositionVo> getCurrPositionAll() {
        String userName = UserUtils.getUser().getUsername();
        return this.tmPositionFeign.getUserPositons(userName, null).getObjList();
    }

    public TmPositionVo getCurrPosition() {
        String posId = UserUtils.getUser().getPosId();
        return (TmPositionVo)this.tmPositionFeign.getPosition(posId, null).getObj();
    }

    public TmOrgVo getCurrOrg() {
        String posId = UserUtils.getUser().getPosId();
        TmOrgVo orgVo = (TmOrgVo)this.tmOrgFeign.getOrgByPos(posId, null).getObj();
        return orgVo;
    }
}

