/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.postman.request.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.postman.request.service.KnlPostRequestService;
import com.biz.eisp.base.postman.response.service.KnlResponseParamService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.postman.request.entity.KnlPostRequestEntity;
import com.biz.eisp.postman.request.vo.KnlPostRequestVo;
import com.biz.eisp.postman.response.vo.KnlResponseParamVo;
import com.biz.eisp.postman.response.vo.ResponseJson;
import com.biz.eisp.postman.response.vo.ResponseObj;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/knlPostRequestController"})
public class KnlPostRequestController {
    @Autowired
    private KnlPostRequestService knlPostRequestService;
    @Autowired
    private KnlResponseParamService knlResponseParamService;

    @RequestMapping(value={"findKnlPostRequestPage"})
    @ResponseBody
    public DataGrid findKnlPostRequestPage(HttpServletRequest request, KnlPostRequestVo vo) {
        EuPage page = new EuPage(request);
        PageInfo<KnlPostRequestVo> knlKnlPostRequestVoPageInfo = this.knlPostRequestService.findKnlPostRequestPage(vo, (Page)page);
        if (knlKnlPostRequestVoPageInfo != null) {
            return new DataGrid(knlKnlPostRequestVoPageInfo);
        }
        return new DataGrid(new ArrayList(), (Page)page);
    }

    @RequestMapping(value={"getKnlPostTable"})
    public AjaxJson getKnlPostTable(String id) {
        AjaxJson ajaxJson = new AjaxJson();
        KnlPostRequestEntity knlPostRequestEntity = this.knlPostRequestService.getKnlPostRequestEntity(id);
        KnlResponseParamVo vo1 = new KnlResponseParamVo();
        vo1.setHeadId(id);
        vo1.setParamLevel("1");
        List<KnlResponseParamVo> knlResponseParamVos1 = this.knlResponseParamService.getKnlResponseParamList(vo1);
        KnlResponseParamVo vo2 = new KnlResponseParamVo();
        vo2.setHeadId(id);
        vo2.setParamLevel("2");
        List<KnlResponseParamVo> knlResponseParamVos2 = this.knlResponseParamService.getKnlResponseParamList(vo2);
        KnlResponseParamVo vo3 = new KnlResponseParamVo();
        vo3.setHeadId(id);
        vo3.setParamLevel("3");
        List<KnlResponseParamVo> knlResponseParamVos3 = this.knlResponseParamService.getKnlResponseParamList(vo3);
        ResponseObj responseObj = new ResponseObj();
        ResponseJson responseJson = new ResponseJson();
        if (knlPostRequestEntity != null) {
            responseObj.setKnlPostRequestEntity(knlPostRequestEntity);
        }
        if (knlResponseParamVos1 != null && knlResponseParamVos1.size() > 0) {
            responseJson.setLevelOne(knlResponseParamVos1);
        } else {
            responseJson.setLevelOne(new ArrayList(0));
        }
        if (knlResponseParamVos2 != null && knlResponseParamVos2.size() > 0) {
            responseJson.setLevelTwo(knlResponseParamVos2);
        } else {
            responseJson.setLevelTwo(new ArrayList(0));
        }
        if (knlResponseParamVos3 != null && knlResponseParamVos3.size() > 0) {
            responseJson.setLevelThree(knlResponseParamVos3);
        } else {
            responseJson.setLevelThree(new ArrayList(0));
        }
        responseObj.setResponseJson(responseJson);
        Object json = JSONObject.toJSON((Object)responseObj);
        ajaxJson.setObj(json);
        return ajaxJson;
    }

    @RequestMapping(value={"deleteKnlPost"})
    public AjaxJson deleteKnlPost(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.knlPostRequestService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"saveRequest"})
    public AjaxJson saveRequest(@RequestBody KnlPostRequestVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getRequestUrl())) {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return j;
            }
            if (StringUtils.isBlank((CharSequence)vo.getParams())) {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return j;
            }
            String id = null;
            id = StringUtils.isNotBlank((CharSequence)vo.getId()) ? this.knlPostRequestService.update(vo) : this.knlPostRequestService.save(vo);
            j.setFlagId(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"sendPostRequest"})
    public AjaxJson sendPostRequest(@RequestBody KnlPostRequestVo vo) {
        AjaxJson j = new AjaxJson();
        try {
            if (StringUtils.isBlank((CharSequence)vo.getRequestUrl())) {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6c42url\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return j;
            }
            if (StringUtils.isBlank((CharSequence)vo.getParams())) {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                return j;
            }
            j = this.knlPostRequestService.sendPostHttp(vo);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff01");
            j.setSuccess(false);
        }
        return j;
    }

    @RequestMapping(value={"startOrStop"})
    public AjaxJson startOrStop(KnlPostRequestVo knlPostRequestVo) {
        AjaxJson json = new AjaxJson();
        try {
            json = this.knlPostRequestService.startOrStop(knlPostRequestVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return json;
    }
}

