/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.signinLogin.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.actcheck.vo.Result;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.signinLogin.dao.KnlSfaappLoginDao;
import com.biz.eisp.base.signinLogin.dao.KnlSigninLoginDao;
import com.biz.eisp.base.signinLogin.dao.KnlSigninLoginMlamDao;
import com.biz.eisp.base.signinLogin.dao.KnlSigninLoginQrcodeDao;
import com.biz.eisp.base.signinLogin.service.KnlSigninLoginService;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.signinLogin.entity.KnlSfaappLoginEntity;
import com.biz.eisp.signinLogin.entity.KnlSigninLoginEntity;
import com.biz.eisp.signinLogin.entity.KnlSigninLoginMlamEntity;
import com.biz.eisp.signinLogin.entity.KnlSigninLoginQrcodeEntity;
import com.biz.eisp.signinLogin.vo.KnlSfaappLoginVo;
import com.biz.eisp.signinLogin.vo.KnlSigninLoginVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service
@Transactional
public class KnlSigninLoginServiceImpl
extends BaseServiceImpl<KnlSigninLoginEntity>
implements KnlSigninLoginService {
    @Autowired
    private KnlSigninLoginDao knlSigninLoginDao;
    @Autowired
    private KnlSigninLoginMlamDao knlSigninLoginMlamDao;
    @Autowired
    private KnlSigninLoginQrcodeDao knlSigninLoginQrcodeDao;
    @Autowired
    private KnlSfaappLoginDao knlSfaappLoginDao;

    @Override
    public KnlSigninLoginVo getKnlSigninLoginById(String id) {
        KnlSigninLoginEntity entity;
        KnlSigninLoginVo knlSigninLoginVo = new KnlSigninLoginVo();
        if (StringUtil.isNotEmpty((CharSequence)id) && null != (entity = (KnlSigninLoginEntity)this.knlSigninLoginDao.selectByPrimaryKey(id))) {
            List<KnlSigninLoginQrcodeEntity> knlSigninLoginQrcodeEntities;
            BeanUtils.copyProperties((Object)entity, (Object)knlSigninLoginVo);
            List<KnlSigninLoginMlamEntity> knlSigninLoginMlams = this.getKnlSigninLoginMlamListByOtherId(entity.getId());
            if (CollectionUtil.listNotEmptyNotSizeZero(knlSigninLoginMlams)) {
                JSONArray array = new JSONArray();
                knlSigninLoginMlams.forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("mlamReal", (Object)item.getMlamReal());
                    obj.put("mlamVurl", (Object)item.getMlamVurl());
                    obj.put("mlamUrl", (Object)item.getMlamUrl());
                    obj.put("mlamName", (Object)item.getMlamName());
                    obj.put("mlamExtend", (Object)item.getMlamExtend());
                    array.add((Object)obj);
                });
                knlSigninLoginVo.setMlamJson(array.toJSONString());
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(knlSigninLoginQrcodeEntities = this.getKnlSigninLoginQrcodeListByOtherId(entity.getId()))) {
                JSONArray array = new JSONArray();
                knlSigninLoginQrcodeEntities.forEach(item -> {
                    JSONObject obj = new JSONObject();
                    obj.put("note", (Object)item.getNote());
                    obj.put("realPath", (Object)item.getRealPath());
                    obj.put("vurlPath", (Object)item.getVurlPath());
                    obj.put("urlPath", (Object)item.getUrlPath());
                    obj.put("fileName", (Object)item.getFileName());
                    obj.put("extend", (Object)item.getExtend());
                    array.add((Object)obj);
                });
                knlSigninLoginVo.setQrcodeJson(array.toJSONString());
            }
        }
        return knlSigninLoginVo;
    }

    public List<KnlSigninLoginMlamEntity> getKnlSigninLoginMlamListByOtherId(String otherId) {
        List<Object> entityList = new ArrayList<KnlSigninLoginMlamEntity>();
        if (StringUtil.isNotEmpty((CharSequence)otherId)) {
            Example example = new Example(KnlSigninLoginMlamEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("otherId", (Object)otherId);
            example.orderBy("groupOrder").asc();
            entityList = this.knlSigninLoginMlamDao.selectByExample(example);
        }
        return entityList;
    }

    @Override
    public List<KnlSigninLoginQrcodeEntity> getKnlSigninLoginQrcodeListByOtherId(String otherId) {
        List<Object> entityList = new ArrayList<KnlSigninLoginQrcodeEntity>();
        if (StringUtil.isNotEmpty((CharSequence)otherId)) {
            Example example = new Example(KnlSigninLoginQrcodeEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("otherId", (Object)otherId);
            example.orderBy("groupOrder").asc();
            entityList = this.knlSigninLoginQrcodeDao.selectByExample(example);
        }
        return entityList;
    }

    @Override
    public PageInfo<KnlSigninLoginEntity> findKnlSigninLoginPage(KnlSigninLoginEntity knlSigninLogin, Page page) {
        Example example = new Example(KnlSigninLoginEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)knlSigninLogin.getTemplateName())) {
            criteria.andLike("templateName", "%" + knlSigninLogin.getTemplateName() + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)knlSigninLogin.getStatus())) {
            criteria.andEqualTo("status", (Object)knlSigninLogin.getStatus());
        }
        example.orderBy("updateDate").desc();
        return PageAutoHelperUtil.generatePage(() -> this.knlSigninLoginDao.selectByExample(example), (Page)page);
    }

    @Override
    public AjaxJson saveOrUpdateSigninLogin(KnlSigninLoginVo knlSigninLoginVo) {
        AjaxJson json = new AjaxJson();
        json.setSuccessMsg("\u4fdd\u5b58\u6210\u529f");
        UserRedis userRedis = UserUtils.getUser();
        String dateStr = DateUtils.datetimeFormat.format(new Date());
        KnlSigninLoginEntity entity = null;
        if (StringUtil.isNotEmpty((CharSequence)knlSigninLoginVo.getId())) {
            entity = (KnlSigninLoginEntity)this.knlSigninLoginDao.selectByPrimaryKey(knlSigninLoginVo.getId());
        }
        if (null != entity) {
            entity = this.getKnlSigninLoginEntity(entity, knlSigninLoginVo);
            if (StringUtil.isEmpty((String)knlSigninLoginVo.getHotline())) {
                entity.setHotline(null);
            }
            if (StringUtil.isEmpty((String)knlSigninLoginVo.getCsPhone())) {
                entity.setCsPhone(null);
            }
            if (StringUtil.isEmpty((String)knlSigninLoginVo.getRecordNum())) {
                entity.setRecordNum(null);
            }
            if (StringUtil.isEmpty((String)knlSigninLoginVo.getCompanyName())) {
                entity.setCompanyName(null);
            }
            entity.setStatus("009");
            entity.setUpdateDate(dateStr);
            entity.setUpdateBy(userRedis.getUsername());
            entity.setUpdateName(userRedis.getRealname());
            entity.setId(knlSigninLoginVo.getId());
            this.knlSigninLoginDao.updateByPrimaryKey(entity);
        } else {
            entity = new KnlSigninLoginEntity();
            entity = this.getKnlSigninLoginEntity(entity, knlSigninLoginVo);
            entity.setStatus("009");
            entity.setPositionCode(userRedis.getPosCode());
            entity.setPositionName(userRedis.getPosName());
            entity.setCreateDate(dateStr);
            entity.setCreateBy(userRedis.getUsername());
            entity.setCreateName(userRedis.getRealname());
            entity.setUpdateDate(dateStr);
            entity.setUpdateBy(userRedis.getUsername());
            entity.setUpdateName(userRedis.getRealname());
            this.knlSigninLoginDao.insertSelective(entity);
        }
        Example mExample = new Example(KnlSigninLoginMlamEntity.class);
        Example.Criteria mCriteria = mExample.createCriteria();
        mCriteria.andEqualTo("otherId", (Object)entity.getId());
        this.knlSigninLoginMlamDao.deleteByExample(mExample);
        if (StringUtil.isNotEmpty((CharSequence)knlSigninLoginVo.getMlamJson())) {
            List mlamEntityList = JSON.parseArray((String)knlSigninLoginVo.getMlamJson(), KnlSigninLoginMlamEntity.class);
            ArrayList<KnlSigninLoginMlamEntity> mlamList = new ArrayList<KnlSigninLoginMlamEntity>();
            Integer groupOrder = 1;
            for (KnlSigninLoginMlamEntity mlamEntity : mlamEntityList) {
                if (StringUtil.isEmpty((String)mlamEntity.getMlamVurl())) continue;
                mlamEntity.setOtherId(entity.getId());
                mlamEntity.setGroupOrder(groupOrder);
                mlamList.add(mlamEntity);
                Integer n = groupOrder;
                Integer n2 = groupOrder = Integer.valueOf(groupOrder + 1);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(mlamList)) {
                this.knlSigninLoginMlamDao.insertList(mlamList);
            }
        }
        Example qrExample = new Example(KnlSigninLoginQrcodeEntity.class);
        Example.Criteria qrCriteria = qrExample.createCriteria();
        qrCriteria.andEqualTo("otherId", (Object)entity.getId());
        this.knlSigninLoginQrcodeDao.deleteByExample(qrExample);
        if (StringUtil.isNotEmpty((CharSequence)knlSigninLoginVo.getQrcodeJson())) {
            List qrcodeEntityList = JSON.parseArray((String)knlSigninLoginVo.getQrcodeJson(), KnlSigninLoginQrcodeEntity.class);
            ArrayList<KnlSigninLoginQrcodeEntity> qrcodeList = new ArrayList<KnlSigninLoginQrcodeEntity>();
            Integer groupOrder = 1;
            for (KnlSigninLoginQrcodeEntity qrcodeEntity : qrcodeEntityList) {
                if (StringUtil.isEmpty((String)qrcodeEntity.getVurlPath())) continue;
                qrcodeEntity.setOtherId(entity.getId());
                qrcodeEntity.setGroupOrder(groupOrder);
                qrcodeList.add(qrcodeEntity);
                Integer n = groupOrder;
                Integer n3 = groupOrder = Integer.valueOf(groupOrder + 1);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(qrcodeList)) {
                this.knlSigninLoginQrcodeDao.insertList(qrcodeList);
            }
        }
        return json;
    }

    private KnlSigninLoginEntity getKnlSigninLoginEntity(KnlSigninLoginEntity entity, KnlSigninLoginVo knlSigninLoginVo) {
        entity.setTitle(knlSigninLoginVo.getTitle());
        entity.setCsPhone(knlSigninLoginVo.getCsPhone());
        entity.setHotline(knlSigninLoginVo.getHotline());
        entity.setRecordNum(knlSigninLoginVo.getRecordNum());
        entity.setBottomWord(knlSigninLoginVo.getBottomWord());
        entity.setLogoExtend(knlSigninLoginVo.getLogoExtend());
        entity.setLogoName(knlSigninLoginVo.getLogoName());
        entity.setLogoReal(knlSigninLoginVo.getLogoReal());
        entity.setLogoUrl(knlSigninLoginVo.getLogoUrl());
        entity.setLogoVurl(knlSigninLoginVo.getLogoVurl());
        entity.setSigninBut(knlSigninLoginVo.getSigninBut());
        entity.setSwiperDelay(knlSigninLoginVo.getSwiperDelay());
        entity.setTemplateName(knlSigninLoginVo.getTemplateName());
        entity.setCompanyName(knlSigninLoginVo.getCompanyName());
        return entity;
    }

    @Override
    public AjaxJson deleteKnlSigninLogin(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u5220\u9664\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            this.knlSigninLoginDao.deleteByPrimaryKey(id);
            Example mExample = new Example(KnlSigninLoginMlamEntity.class);
            Example.Criteria mCriteria = mExample.createCriteria();
            mCriteria.andEqualTo("otherId", (Object)id);
            this.knlSigninLoginMlamDao.deleteByExample(mExample);
            Example example = new Example(KnlSigninLoginQrcodeEntity.class);
            Example.Criteria criteria = example.createCriteria();
            criteria.andEqualTo("otherId", (Object)id);
            this.knlSigninLoginQrcodeDao.deleteByExample(example);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson startSigninLogin(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u542f\u7528\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            KnlSigninLoginEntity entity = (KnlSigninLoginEntity)this.knlSigninLoginDao.selectByPrimaryKey(id);
            if (null == entity || "009".equals(entity.getStatus())) continue;
            entity.setStatus("009");
            this.knlSigninLoginDao.updateByPrimaryKey(entity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson stopSigninLogin(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u505c\u7528\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            KnlSigninLoginEntity entity = (KnlSigninLoginEntity)this.knlSigninLoginDao.selectByPrimaryKey(id);
            if (null == entity || "003".equals(entity.getStatus())) continue;
            entity.setStatus("003");
            this.knlSigninLoginDao.updateByPrimaryKey(entity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson findSigninLogin() {
        AjaxJson ajaxJson = new AjaxJson();
        Example example = new Example(KnlSigninLoginEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", (Object)"009");
        example.orderBy("updateDate").desc();
        List knlSigninLogins = this.knlSigninLoginDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)knlSigninLogins)) {
            KnlSigninLoginVo knlSigninLoginVo = new KnlSigninLoginVo();
            BeanUtils.copyProperties(knlSigninLogins.get(0), (Object)knlSigninLoginVo);
            if (null != knlSigninLoginVo && StringUtil.isNotEmpty((CharSequence)knlSigninLoginVo.getId())) {
                List<KnlSigninLoginMlamEntity> knlSigninLoginMlamEntities = this.getKnlSigninLoginMlamListByOtherId(knlSigninLoginVo.getId());
                knlSigninLoginVo.setMlamList(knlSigninLoginMlamEntities);
                List<KnlSigninLoginQrcodeEntity> knlSigninLoginQrcodeEntities = this.getKnlSigninLoginQrcodeListByOtherId(knlSigninLoginVo.getId());
                knlSigninLoginVo.setQrcodeList(knlSigninLoginQrcodeEntities);
            }
            ajaxJson.setObj((Object)knlSigninLoginVo);
        }
        return ajaxJson;
    }

    @Override
    public PageInfo<KnlSfaappLoginEntity> findKnlSfaappLoginPage(KnlSfaappLoginEntity knlSfaappLogin, Page page) {
        Example example = new Example(KnlSfaappLoginEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)knlSfaappLogin.getTemplateName())) {
            criteria.andLike("templateName", "%" + knlSfaappLogin.getTemplateName() + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)knlSfaappLogin.getStatus())) {
            criteria.andEqualTo("status", (Object)knlSfaappLogin.getStatus());
        }
        example.orderBy("updateDate").desc();
        return PageAutoHelperUtil.generatePage(() -> this.knlSfaappLoginDao.selectByExample(example), (Page)page);
    }

    @Override
    public KnlSfaappLoginVo getKnlSfaappLoginById(String id) {
        KnlSfaappLoginEntity entity;
        KnlSfaappLoginVo knlSfaappLoginVo = new KnlSfaappLoginVo();
        if (StringUtil.isNotEmpty((CharSequence)id) && null != (entity = (KnlSfaappLoginEntity)this.knlSfaappLoginDao.selectByPrimaryKey(id))) {
            BeanUtils.copyProperties((Object)entity, (Object)knlSfaappLoginVo);
        }
        return knlSfaappLoginVo;
    }

    @Override
    public AjaxJson saveOrUpdateSfaappLogin(KnlSfaappLoginVo knlSfaappLoginVo) {
        AjaxJson json = new AjaxJson();
        json.setSuccessMsg("\u4fdd\u5b58\u6210\u529f");
        UserRedis userRedis = UserUtils.getUser();
        String dateStr = DateUtils.datetimeFormat.format(new Date());
        KnlSfaappLoginEntity entity = null;
        if (StringUtil.isNotEmpty((CharSequence)knlSfaappLoginVo.getId())) {
            entity = (KnlSfaappLoginEntity)this.knlSfaappLoginDao.selectByPrimaryKey(knlSfaappLoginVo.getId());
        }
        if (null != entity) {
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)knlSfaappLoginVo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException(e.getMessage());
            }
            entity.setStatus("009");
            entity.setUpdateDate(dateStr);
            entity.setUpdateBy(userRedis.getUsername());
            entity.setUpdateName(userRedis.getRealname());
            this.knlSfaappLoginDao.updateByPrimaryKey(entity);
        } else {
            entity = new KnlSfaappLoginEntity();
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)knlSfaappLoginVo, (Object)entity);
            }
            catch (Exception e) {
                throw new BusinessException(e.getMessage());
            }
            entity.setStatus("009");
            entity.setPositionCode(userRedis.getPosCode());
            entity.setPositionName(userRedis.getPosName());
            entity.setCreateDate(dateStr);
            entity.setCreateBy(userRedis.getUsername());
            entity.setCreateName(userRedis.getRealname());
            entity.setUpdateDate(dateStr);
            entity.setUpdateBy(userRedis.getUsername());
            entity.setUpdateName(userRedis.getRealname());
            this.knlSfaappLoginDao.insertSelective(entity);
        }
        return json;
    }

    @Override
    public AjaxJson deleteKnlSfaappLogin(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u5220\u9664\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            this.knlSfaappLoginDao.deleteByPrimaryKey(id);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson startSfaappLogin(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u542f\u7528\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            KnlSfaappLoginEntity entity = (KnlSfaappLoginEntity)this.knlSfaappLoginDao.selectByPrimaryKey(id);
            if (null == entity || "009".equals(entity.getStatus())) continue;
            entity.setStatus("009");
            this.knlSfaappLoginDao.updateByPrimaryKey(entity);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson stopSfaappLogin(String ids) {
        String[] idsArr;
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson.setSuccessMsg("\u505c\u7528\u6210\u529f");
        for (String id : idsArr = ids.split(",")) {
            KnlSfaappLoginEntity entity = (KnlSfaappLoginEntity)this.knlSfaappLoginDao.selectByPrimaryKey(id);
            if (null == entity || "003".equals(entity.getStatus())) continue;
            entity.setStatus("003");
            this.knlSfaappLoginDao.updateByPrimaryKey(entity);
        }
        return ajaxJson;
    }

    @Override
    public Result findSfaappLogin() {
        Result result = new Result();
        Example example = new Example(KnlSigninLoginEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("status", (Object)"009");
        example.orderBy("updateDate").desc();
        List knlSfaappLogins = this.knlSfaappLoginDao.selectByExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)knlSfaappLogins)) {
            KnlSfaappLoginVo knlSfaappLoginVo = new KnlSfaappLoginVo();
            BeanUtils.copyProperties(knlSfaappLogins.get(0), (Object)knlSfaappLoginVo);
            result.setObj((Object)knlSfaappLoginVo);
        }
        return result;
    }
}

