/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.timeTask.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.DateUtils;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.timeTask.dao.ScheduleJobDao;
import com.biz.eisp.base.timeTask.service.ScheduleJobService;
import com.biz.eisp.base.timeTask.util.CompareUtil;
import com.biz.eisp.base.timeTask.util.ScheduleUtils;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.timeJob.entity.SchedulejobEntity;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.Date;
import org.quartz.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="scheduleJobService")
@Transactional
public class ScheduleJobServiceImplImpl
extends BaseServiceImpl<SchedulejobEntity>
implements ScheduleJobService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private ScheduleJobDao scheduleJobDao;

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=ScheduleJobServiceImplImpl.class)
    public int creatScheduleJob(SchedulejobEntity o) {
        int res = 0;
        try {
            o.setCreateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (o.getStatus() != null && o.getStatus() == 1) {
                ScheduleUtils.createScheduleJob(this.scheduler, o);
            }
            this.insertSelective(o);
            res = 1;
        }
        catch (BusinessException e) {
            this.logger.error("\u521b\u5efa\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        return res;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=ScheduleJobServiceImplImpl.class)
    public int updateScheduleJob(SchedulejobEntity o) {
        int res = 0;
        try {
            SchedulejobEntity scheduleJob = (SchedulejobEntity)this.scheduleJobDao.selectByPrimaryKey(o.getId());
            ScheduleUtils.deleteScheduleJob(this.scheduler, scheduleJob.getJobName(), scheduleJob.getJobGroup());
            if (o.getStatus() != null && o.getStatus() == 1) {
                ScheduleUtils.createScheduleJob(this.scheduler, o);
            }
            o.setUpdateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            MyBeanUtils.copyBeanNotNull2Bean((Object)o, (Object)scheduleJob);
            this.updateByPrimaryKeySelective(scheduleJob);
            res = 1;
        }
        catch (BusinessException e) {
            this.logger.error("\u521b\u5efa\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        return res;
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=ScheduleJobServiceImplImpl.class)
    public int deleteScheduleJob(SchedulejobEntity o) {
        int res = 0;
        try {
            SchedulejobEntity scheduleJob = (SchedulejobEntity)this.scheduleJobDao.selectByPrimaryKey(o.getId());
            ScheduleUtils.deleteScheduleJob(this.scheduler, scheduleJob.getJobName(), scheduleJob.getJobGroup());
            this.delete(scheduleJob);
            res = 1;
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        return res;
    }

    @Override
    public int runOnce(SchedulejobEntity o) {
        int res;
        block6: {
            res = 0;
            try {
                SchedulejobEntity scheduleJob = (SchedulejobEntity)this.scheduleJobDao.selectByPrimaryKey(o.getId());
                if (scheduleJob.getStatus() != null && scheduleJob.getStatus() == 1) {
                    res = 2;
                    break block6;
                }
                ScheduleUtils.createScheduleJob(this.scheduler, scheduleJob);
                ScheduleUtils.runOnce(this.scheduler, scheduleJob.getJobName(), scheduleJob.getJobGroup());
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ScheduleUtils.deleteScheduleJob(this.scheduler, scheduleJob.getJobName(), scheduleJob.getJobGroup());
                res = 1;
            }
            catch (BusinessException e) {
                this.logger.error("\u8fd0\u884c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
            catch (Exception e) {
                this.logger.error("\u8fd0\u884c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
            }
        }
        return res;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=ScheduleJobServiceImplImpl.class)
    public int pauseJob(SchedulejobEntity o) {
        int res = 0;
        try {
            SchedulejobEntity scheduleJob = (SchedulejobEntity)this.scheduleJobDao.selectByPrimaryKey(o.getId());
            if (scheduleJob.getStatus() != null && scheduleJob.getStatus() == 1) {
                ScheduleUtils.deleteScheduleJob(this.scheduler, scheduleJob.getJobName(), scheduleJob.getJobGroup());
                scheduleJob.setStatus(Integer.valueOf(0));
                scheduleJob.setUpdateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.updateByPrimaryKeySelective(scheduleJob);
                res = 1;
            } else {
                res = 2;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e);
        }
        return res;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=ScheduleJobServiceImplImpl.class)
    public int resumeJob(SchedulejobEntity o) {
        int res = 0;
        SchedulejobEntity scheduleJob = (SchedulejobEntity)this.scheduleJobDao.selectByPrimaryKey(o.getId());
        if (scheduleJob.getStatus() != null && CompareUtil.eq(scheduleJob.getStatus(), 0)) {
            ScheduleUtils.createScheduleJob(this.scheduler, scheduleJob);
            scheduleJob.setStatus(Integer.valueOf(1));
            scheduleJob.setUpdateDate(DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.updateByPrimaryKeySelective(scheduleJob);
            res = 1;
        } else {
            res = 2;
        }
        return res;
    }

    @Override
    public PageInfo<SchedulejobEntity> findTaskPage(SchedulejobEntity o, Page page) {
        Example example = new Example(SchedulejobEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((Object)o.getStatus())) {
            criteria.andEqualTo("status", (Object)o.getStatus());
        }
        return PageAutoHelperUtil.generatePage(() -> this.scheduleJobDao.selectByExample(example), (Page)page);
    }

    @Override
    public SchedulejobEntity getSchedulejobEntity(String id) {
        return (SchedulejobEntity)this.scheduleJobDao.selectByPrimaryKey(id);
    }
}

