/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.used.service.impl;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.budget.fee.dao.TtFeeBudgetDao;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.budget.income.dao.TtIncomeBudgetDao;
import com.biz.eisp.budget.income.entity.TtIncomeBudgetEntity;
import com.biz.eisp.budget.income.service.TtIncomeBudgetService;
import com.biz.eisp.budget.used.dao.TtBudgutDetailDao;
import com.biz.eisp.budget.used.entity.TtBudgutDetailEntity;
import com.biz.eisp.budget.used.operation.BudgetOperation;
import com.biz.eisp.budget.used.operation.OperationFactory;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.klock.annotation.Klock;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttBudgutDetailService")
@Transactional
public class TtBudgutDetailServiceImpl
extends BaseServiceImpl<TtBudgutDetailEntity>
implements TtBudgutDetailService {
    @Autowired
    private TtBudgutDetailDao ttBudgutDetailDao;
    @Autowired
    private TtFeeBudgetService ttFeeBudgetService;
    @Autowired
    private TtIncomeBudgetService ttIncomeBudgetService;
    @Autowired
    private TtFeeBudgetDao ttFeeBudgetDao;
    @Autowired
    private TtIncomeBudgetDao ttIncomeBudgetDao;
    @Autowired
    private TtBudgetSubjectsService ttBudgetSubjectsService;

    @Override
    @Klock(keys={"#feeUseBudgutParam.bugetCode"})
    public AjaxJson saveFeeBudgutDetail(FeeUseBudgutParam feeUseBudgutParam) {
        AjaxJson ajaxJson = new AjaxJson();
        TtBudgutDetailEntity entity = new TtBudgutDetailEntity();
        TtFeeBudgetEntity feeBudgetEntity = this.ttFeeBudgetService.getEntity("", feeUseBudgutParam.getBugetCode());
        if (feeBudgetEntity == null || StringUtil.isBlank((CharSequence)feeUseBudgutParam.getType()) || feeUseBudgutParam.getAmount() == null || feeUseBudgutParam.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
            ajaxJson.setErrMsg("\u5360\u7528\u6263\u51cf\u9884\u7b97\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        if (StringUtil.equals((String)ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue(), (String)feeUseBudgutParam.getType()) || StringUtil.equals((String)ConstantEnum.BudgetUesdTypeEnum.CUTOUT.getValue(), (String)feeUseBudgutParam.getType()) || StringUtil.equals((String)ConstantEnum.BudgetUesdTypeEnum.USE.getValue(), (String)feeUseBudgutParam.getType())) {
            TtBudgetSubjectsEntity subjectsEntity = this.ttBudgetSubjectsService.getEntity(null, feeBudgetEntity.getBudgetSubjectsCode());
            if (StringUtil.equals((String)ConstantEnum.YesNoEnum.ONE.getValue(), (String)subjectsEntity.getIsBudgetControl()) && feeUseBudgutParam.getAmount().compareTo(feeBudgetEntity.getAmount()) > 0) {
                ajaxJson.setErrMsg("\u9884\u7b97\uff1a" + feeBudgetEntity.getBudgetCode() + " \u5f53\u524d\u4f59\u989d:" + feeBudgetEntity.getAmount() + "\u8d85\u51fa\u4f7f\u7528\u91d1\u989d");
                return ajaxJson;
            }
        }
        BudgetOperation budgetOperation = OperationFactory.getOperation(feeUseBudgutParam.getType()).orElseThrow(() -> new IllegalArgumentException("\u6ca1\u6709\u5b9a\u4e49\u5904\u7406\u903b\u8f91"));
        budgetOperation.doFee(entity, feeBudgetEntity, feeUseBudgutParam.getAmount(), feeUseBudgutParam.getNote(), feeUseBudgutParam.getFromAddress(), feeUseBudgutParam);
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.ttBudgutDetailDao.insertSelective(entity);
        TtFeeBudgetEntity updateFee = new TtFeeBudgetEntity();
        updateFee.setId(feeBudgetEntity.getId());
        updateFee.setAmount(entity.getAfterAmount());
        this.ttFeeBudgetDao.updateByPrimaryKeySelective(updateFee);
        return ajaxJson;
    }

    @Override
    public void incomeFeeBudgutDetail(String bugetCode, String type, BigDecimal amount, String note) {
        TtBudgutDetailEntity entity = new TtBudgutDetailEntity();
        TtIncomeBudgetEntity ttIncomeBudgetEntity = this.ttIncomeBudgetService.getEntity("", bugetCode);
        if (!ConstantEnum.BudgetUesdTypeEnum.INIT.getValue().equals(type)) {
            return;
        }
        BigDecimal usableAmount = ttIncomeBudgetEntity.getAmount() == null ? BigDecimal.ZERO : ttIncomeBudgetEntity.getAmount();
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        entity.setBudgetCode(bugetCode);
        entity.setNotes(note);
        entity.setFeeAmount(amount);
        entity.setBeforAmount(usableAmount);
        entity.setAfterAmount(usableAmount.add(amount));
        entity.setInitAmount(ttIncomeBudgetEntity.getInitAmount());
        entity.setFromAddress("tt_income_budget");
        this.ttBudgutDetailDao.insertSelective(entity);
        TtIncomeBudgetEntity updateFee = new TtIncomeBudgetEntity();
        updateFee.setId(ttIncomeBudgetEntity.getId());
        updateFee.setAmount(entity.getAfterAmount());
        this.ttIncomeBudgetDao.updateByPrimaryKeySelective(updateFee);
    }

    @Override
    public PageInfo<TtBudgutDetailEntity> getMaiList(TtBudgutDetailEntity entity, Page page) {
        Example example = new Example(TtBudgutDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("budgetCode", (Object)entity.getBudgetCode());
        example.setOrderByClause(" create_date desc ");
        return PageAutoHelperUtil.generatePage(() -> this.ttBudgutDetailDao.selectByExample(example), (Page)page);
    }

    @Override
    public List<TtBudgutDetailEntity> getMaiList(TtBudgutDetailEntity entity) {
        Example example = new Example(TtBudgutDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("budgetCode", (Object)entity.getBudgetCode());
        if (StringUtil.isNotEmpty((CharSequence)entity.getTypeCode())) {
            criteria.andEqualTo("typeCode", (Object)entity.getTypeCode());
        }
        example.setOrderByClause(" create_date desc ");
        return this.ttBudgutDetailDao.selectByExample(example);
    }

    @Override
    public PageInfo<TtBudgutDetailEntity> getMaiReportList(TtBudgutDetailEntity entity, Page page) {
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttBudgutDetailDao.findTtBudgutDetailListPage(entity), (Page)page);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)pageInfo.getList())) {
            pageInfo.getList().forEach(item -> {
                if (StringUtil.isNotEmpty((CharSequence)item.getTypeCode())) {
                    if (StringUtil.equals((String)ConstantEnum.BudgetUesdTypeEnum.ADDITIONAL.getValue(), (String)item.getTypeCode())) {
                        item.setAdditionalMoney(item.getFeeAmount());
                    }
                    if (StringUtil.equals((String)ConstantEnum.BudgetUesdTypeEnum.CUTOUT.getValue(), (String)item.getTypeCode())) {
                        item.setCutoutMoney(item.getFeeAmount());
                    }
                    if (StringUtil.equals((String)ConstantEnum.BudgetUesdTypeEnum.USE.getValue(), (String)item.getTypeCode())) {
                        item.setUseMoney(item.getFeeAmount());
                    }
                    if (StringUtil.equals((String)ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue(), (String)item.getTypeCode())) {
                        item.setAdjustOutMoney(item.getFeeAmount());
                    }
                    if (StringUtil.equals((String)ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue(), (String)item.getTypeCode())) {
                        item.setAdjustImportMoney(item.getFeeAmount());
                    }
                }
            });
        }
        return pageInfo;
    }
}

