/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.used.operation;

import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.used.operation.BudgetOperation;
import com.biz.eisp.budget.used.operation.impl.AdditionalFeeBudget;
import com.biz.eisp.budget.used.operation.impl.AdjustImportFeeBudget;
import com.biz.eisp.budget.used.operation.impl.AdjustOutFeeBudget;
import com.biz.eisp.budget.used.operation.impl.BackFeeBudget;
import com.biz.eisp.budget.used.operation.impl.CutoutFeeBudget;
import com.biz.eisp.budget.used.operation.impl.InitFeeBudget;
import com.biz.eisp.budget.used.operation.impl.UseFeeBudget;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class OperationFactory {
    static Map<String, BudgetOperation> operationMap = new HashMap<String, BudgetOperation>();

    public static Optional<BudgetOperation> getOperation(String key) {
        return Optional.ofNullable(operationMap.get(key));
    }

    static {
        operationMap.put(ConstantEnum.BudgetUesdTypeEnum.INIT.getValue(), new InitFeeBudget());
        operationMap.put(ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue(), new AdjustOutFeeBudget());
        operationMap.put(ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue(), new AdjustImportFeeBudget());
        operationMap.put(ConstantEnum.BudgetUesdTypeEnum.ADDITIONAL.getValue(), new AdditionalFeeBudget());
        operationMap.put(ConstantEnum.BudgetUesdTypeEnum.CUTOUT.getValue(), new CutoutFeeBudget());
        operationMap.put(ConstantEnum.BudgetUesdTypeEnum.USE.getValue(), new UseFeeBudget());
        operationMap.put(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue(), new BackFeeBudget());
    }
}

