/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.fee.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.user.UserRedis;
import com.biz.eisp.base.common.util.ApiResultUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.SqlUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.base.pojo.glob.vo.FeeUseBudgutParam;
import com.biz.eisp.base.utils.UserUtils;
import com.biz.eisp.budget.fee.dao.TtFeeBudgetDao;
import com.biz.eisp.budget.fee.entity.TtFeeBudgetEntity;
import com.biz.eisp.budget.fee.service.BudgetAmountExtend;
import com.biz.eisp.budget.fee.service.BudgetAuthorityExtend;
import com.biz.eisp.budget.fee.service.BudgetGetMaiListAuthExpand;
import com.biz.eisp.budget.fee.service.TtFeeBudgetService;
import com.biz.eisp.budget.fee.vo.AdjustAmountVo;
import com.biz.eisp.budget.fee.vo.BudgetAuthorityVo;
import com.biz.eisp.budget.used.entity.TtBudgutDetailEntity;
import com.biz.eisp.budget.used.service.TtBudgutDetailService;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.feign.OperationFeign;
import com.biz.eisp.mdm.vo.OperationAuthobj;
import com.biz.eisp.operation.OperationConfig;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.surplus.Service.TtCustPostService;
import com.biz.eisp.thread.ThreadLocalUtil;
import com.biz.eisp.tools.CodeRuleUtil;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttFeeBudgetService")
@Transactional
public class TtFeeBudgetServiceImpl
extends BaseServiceImpl<TtFeeBudgetEntity>
implements TtFeeBudgetService {
    @Autowired
    private TtFeeBudgetDao ttFeeBudgetDao;
    @Autowired
    private TtBudgutDetailService ttBudgutDetailService;
    @Autowired
    private TtCustPostService ttCustPostService;
    @Autowired(required=false)
    private BudgetAuthorityExtend budgetAuthorityExtend;
    @Autowired(required=false)
    private BudgetAmountExtend budgetAmountExtend;
    @Autowired
    private OperationFeign operationFeign;
    @Autowired(required=false)
    private BudgetGetMaiListAuthExpand budgetGetMaiListAuthExpand;

    @Override
    public void updateBudgetSubjectsName(String budgetSubjectsName, String budgetSubjectsCode) {
        this.ttFeeBudgetDao.updateBudgetSubjectsName(budgetSubjectsName, budgetSubjectsCode);
    }

    @Override
    public PageInfo<TtFeeBudgetEntity> getMaiListSelect(TtFeeBudgetEntity ttFeeBudgetEntity, Page page) {
        BudgetAuthorityVo budgetAuthorityVo = null;
        if (this.budgetAuthorityExtend != null) {
            budgetAuthorityVo = this.budgetAuthorityExtend.createBudgetAuthority();
        }
        if (budgetAuthorityVo != null) {
            if (budgetAuthorityVo.getBudgetSubjectsCode() != null) {
                budgetAuthorityVo.getBudgetSubjectsCode().add("_");
            }
            if (budgetAuthorityVo.getVkorgCode() != null) {
                budgetAuthorityVo.getVkorgCode().add("_");
            }
            if (budgetAuthorityVo.getBudgetDepartCode() != null) {
                budgetAuthorityVo.getBudgetDepartCode().add("_");
            }
            if (budgetAuthorityVo.getProductCode() != null) {
                budgetAuthorityVo.getProductCode().add("_");
            }
            if (budgetAuthorityVo.getCustCode() != null) {
                budgetAuthorityVo.getCustCode().add("_");
            }
            if (budgetAuthorityVo.getTerminalCode() != null) {
                budgetAuthorityVo.getTerminalCode().add("_");
            }
            if (budgetAuthorityVo.getPositionCode() != null) {
                budgetAuthorityVo.getPositionCode().add("_");
            }
            if (budgetAuthorityVo.getCustOrgCode() != null) {
                budgetAuthorityVo.getCustOrgCode().add("_");
            }
        }
        BudgetAuthorityVo budgetAuthorityVoTemp = budgetAuthorityVo;
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttFeeBudgetDao.getMaiListSelect(ttFeeBudgetEntity, budgetAuthorityVoTemp), (Page)page);
        if (this.budgetAmountExtend != null) {
            this.budgetAmountExtend.budgetAmount(pageInfo.getList());
        }
        return pageInfo;
    }

    @Override
    public PageInfo<TtFeeBudgetEntity> getMaiList(TtFeeBudgetEntity ttFeeBudgetEntity, Page page) {
        List authEntities;
        StringBuffer buffer = new StringBuffer();
        String funId = ThreadLocalUtil.getVal();
        UserRedis userRedis = UserUtils.getUser();
        Object flag = null;
        if (StringUtil.isNotBlank((CharSequence)funId) && userRedis != null && !Globals.Admin_Name.equals(userRedis.getUsername()) && CollectionUtil.listNotEmptyNotSizeZero((List)(authEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findListByFunidAndFuncode(funId, Globals.VIEW), (boolean)true)))) {
            buffer.append(" and (");
            List authobjs = ApiResultUtil.listResult((AjaxJson)this.operationFeign.findAuthobjUserAndFunIdAndFuncode(userRedis.getId(), funId, Globals.VIEW), (boolean)true);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)authobjs)) {
                if (!OperationConfig.checAll((List)authobjs)) {
                    String expandSql;
                    Map<Object, Object> auValMap;
                    List items;
                    HashMap<String, List<OperationAuthobj>> auMap = new HashMap<String, List<OperationAuthobj>>();
                    authobjs.stream().collect(Collectors.groupingBy(OperationAuthobj::getAuthobj, Collectors.toList())).forEach((parentId, list) -> auMap.put((String)parentId, (List<OperationAuthobj>)list));
                    boolean flagOr = false;
                    if (auMap.containsKey("org")) {
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("org");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            List codes = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getOrgCodesDownByUser(userRedis.getId(), userRedis.getUsername()), (boolean)true);
                            String temp = SqlUtil.setSqlIn500((List)codes, (String)"a.budget_depart_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            buffer.append("  a.budget_depart_code = '" + userRedis.getOrgCode() + "' ");
                        }
                        buffer.append(")");
                    }
                    if (auMap.containsKey("customer")) {
                        List<String> custCodes;
                        List customerEntities;
                        if (flagOr) {
                            buffer.append(" or ");
                        }
                        flagOr = true;
                        buffer.append(" (");
                        items = (List)auMap.get("customer");
                        auValMap = new HashMap();
                        auValMap = items.stream().collect(Collectors.toMap(OperationAuthobj::getAuthobjValue, item -> item));
                        if (auValMap.containsKey("20")) {
                            customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByOrgDown(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                            custCodes = new ArrayList<String>();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            } else {
                                custCodes.add("_");
                            }
                            String temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("30")) {
                            customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByOrg(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                            custCodes = new ArrayList();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            } else {
                                custCodes.add("_");
                            }
                            String temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("40")) {
                            customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPosDown(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                            custCodes = new ArrayList();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            } else {
                                custCodes.add("_");
                            }
                            String temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                            buffer.append(temp);
                        } else if (auValMap.containsKey("50")) {
                            customerEntities = ApiResultUtil.listResult((AjaxJson)this.operationFeign.getCustListByPos(userRedis.getOrgId(), userRedis.getOrgCode()), (boolean)true);
                            custCodes = new ArrayList();
                            if (CollectionUtil.listNotEmptyNotSizeZero((List)customerEntities)) {
                                custCodes = customerEntities.stream().map(TmCustomerEntity::getCustomerCode).collect(Collectors.toList());
                            } else {
                                custCodes.add("_");
                            }
                            String temp = SqlUtil.setSqlIn500(custCodes, (String)"a.cust_code", (boolean)true);
                            buffer.append(temp);
                        }
                        buffer.append(")");
                    }
                    if (this.budgetGetMaiListAuthExpand != null && StringUtil.isNotEmpty((CharSequence)(expandSql = this.budgetGetMaiListAuthExpand.getMaiListAuth(auMap, userRedis, flagOr, buffer)))) {
                        buffer.append(expandSql);
                    }
                } else {
                    buffer.append(" 1=1");
                }
            } else {
                buffer.append("1=2");
            }
            buffer.append(" ) ");
        }
        String aUsql = buffer.toString();
        PageInfo pageInfo = PageAutoHelperUtil.generatePage(() -> this.ttFeeBudgetDao.getMaiList(ttFeeBudgetEntity, aUsql), (Page)page);
        return pageInfo;
    }

    private BigDecimal getMoney(String typeCode, String budgetCode) {
        TtBudgutDetailEntity ttBudgutDetailEntity = new TtBudgutDetailEntity();
        ttBudgutDetailEntity.setBudgetCode(budgetCode);
        ttBudgutDetailEntity.setTypeCode(typeCode);
        List<TtBudgutDetailEntity> ttBudgutDetailEntities = this.ttBudgutDetailService.getMaiList(ttBudgutDetailEntity);
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (TtBudgutDetailEntity entity : ttBudgutDetailEntities) {
            bigDecimal = bigDecimal.add(entity.getFeeAmount());
        }
        return bigDecimal;
    }

    @Override
    public TtFeeBudgetEntity getEntity(String id, String budgetCode) {
        List list;
        if (StringUtil.isEmpty((String)id) && StringUtil.isEmpty((String)budgetCode)) {
            return null;
        }
        Example example = new Example(TtFeeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)id)) {
            criteria.andEqualTo("id", (Object)id);
        }
        if (StringUtil.isNotEmpty((CharSequence)budgetCode)) {
            criteria.andEqualTo("budgetCode", (Object)budgetCode);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(list = this.ttFeeBudgetDao.selectByExample(example)))) {
            return (TtFeeBudgetEntity)list.get(0);
        }
        return null;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtFeeBudgetServiceImpl.class)
    public AjaxJson update(TtFeeBudgetEntity entity, AjaxJson ajaxJson) {
        entity.setInitAmount(null);
        this.ttFeeBudgetDao.updateByPrimaryKeySelective(entity);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson updateAmount(TtFeeBudgetEntity ttFeeBudgetEntity, AjaxJson ajaxJson) {
        if (ttFeeBudgetEntity.getAmountUpdate() == null) {
            ajaxJson.setErrMsg("\u53d8\u66f4\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(ttFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam.setType(ttFeeBudgetEntity.getChangeType());
        feeUseBudgutParam.setAmount(ttFeeBudgetEntity.getAmountUpdate());
        feeUseBudgutParam.setNote(ttFeeBudgetEntity.getNotes());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (StringUtil.isNotEmpty((CharSequence)ttFeeBudgetEntity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(ttFeeBudgetEntity.getBudgetCode(), ttFeeBudgetEntity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtFeeBudgetServiceImpl.class)
    public AjaxJson save(TtFeeBudgetEntity entity, AjaxJson ajaxJson) {
        if (entity.getInitAmount() == null) {
            ajaxJson.setErrMsg("\u521d\u59cb\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxJson;
        }
        entity.setBudgetCode(CodeRuleUtil.getKnlCodingRulesString((String)ConstantEnum.BUSINESSKEY.fee_budget.name()));
        entity.setEnableStatus(ConstantEnum.StatusEnum.NEW.getValue());
        this.ttFeeBudgetDao.insertSelective(entity);
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(entity.getBudgetCode());
        feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.INIT.getValue());
        feeUseBudgutParam.setAmount(entity.getInitAmount());
        feeUseBudgutParam.setNote("\u65b0\u589e");
        this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (StringUtil.isNotEmpty((CharSequence)entity.getCustCode())) {
            this.ttCustPostService.saveCustTermPost(entity.getBudgetCode(), entity.getCustCode(), null);
        }
        return ajaxJson;
    }

    @Override
    public AjaxJson delete(String id, AjaxJson ajaxJson) {
        TtFeeBudgetEntity ttFeeBudgetEntity = (TtFeeBudgetEntity)this.ttFeeBudgetDao.selectByPrimaryKey(id);
        Example example = new Example(TtBudgutDetailEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andEqualTo("budgetCode", (Object)ttFeeBudgetEntity.getBudgetCode());
        ArrayList<String> list = new ArrayList<String>();
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.ADDITIONAL.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.CUTOUT.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.USE.getValue());
        list.add(ConstantEnum.BudgetUesdTypeEnum.BACK.getValue());
        criteria.andIn("typeCode", list);
        List ttBudgutDetailEntities = this.ttBudgutDetailService.selectExample(example);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)ttBudgutDetailEntities)) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u9884\u7b97\u7f16\u53f7\u4e3a" + ttFeeBudgetEntity.getBudgetCode() + "\u7684\u8d39\u7528\u9884\u7b97\u5df2\u7ecf\u4ea7\u751f\u660e\u7ec6\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            return ajaxJson;
        }
        TtFeeBudgetEntity entity = new TtFeeBudgetEntity();
        entity.setEnableStatus(ConstantEnum.StatusEnum.DELETE.getValue());
        entity.setId(id);
        this.ttFeeBudgetDao.updateByPrimaryKeySelective(entity);
        return ajaxJson;
    }

    @Override
    public List<TtFeeBudgetEntity> getEntityByCodes(List<String> budgetCodes) {
        Example example = new Example(TtFeeBudgetEntity.class);
        Example.Criteria criteria = example.createCriteria();
        criteria.andIn("budgetCode", budgetCodes);
        return this.ttFeeBudgetDao.selectByExample(example);
    }

    @Override
    public AjaxJson adjustAmount(AdjustAmountVo adjustAmountVo, AjaxJson ajaxJson) {
        if (StringUtil.isEmpty((String)adjustAmountVo.getSrcId()) || StringUtil.isEmpty((String)adjustAmountVo.getTarId())) {
            ajaxJson.setErrMsg("\u53c2\u6570\u9519\u8bef");
            return ajaxJson;
        }
        TtFeeBudgetEntity srcFeeBudgetEntity = this.getEntity(adjustAmountVo.getSrcId(), null);
        TtFeeBudgetEntity tarFeeBudgetEntity = this.getEntity(adjustAmountVo.getTarId(), null);
        FeeUseBudgutParam feeUseBudgutParam = new FeeUseBudgutParam();
        feeUseBudgutParam.setBugetCode(srcFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam.setType(ConstantEnum.BudgetUesdTypeEnum.ADJUST_OUT.getValue());
        feeUseBudgutParam.setAmount(adjustAmountVo.getAmountUpdate());
        feeUseBudgutParam.setNote(adjustAmountVo.getNotes());
        feeUseBudgutParam.setBusinessCode(tarFeeBudgetEntity.getBudgetCode());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam);
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        FeeUseBudgutParam feeUseBudgutParam1 = new FeeUseBudgutParam();
        feeUseBudgutParam1.setBugetCode(tarFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam1.setType(ConstantEnum.BudgetUesdTypeEnum.ADJUST_IMPORT.getValue());
        feeUseBudgutParam1.setAmount(adjustAmountVo.getAmountUpdate());
        feeUseBudgutParam1.setNote(adjustAmountVo.getNotes());
        feeUseBudgutParam1.setFromAddress(srcFeeBudgetEntity.getBudgetCode());
        feeUseBudgutParam1.setBusinessCode(srcFeeBudgetEntity.getBudgetCode());
        ajaxJson = this.ttBudgutDetailService.saveFeeBudgutDetail(feeUseBudgutParam1);
        return ajaxJson;
    }
}

