/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.api.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesExtendEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineDetailEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.CategoriesExtendService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.budget.config.vo.TtCostTypeParamVo;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"ttApiCostTypeController"})
@RestController
public class TtApiCostTypeController {
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private CategoriesExtendService categoriesExtendService;

    @GetMapping(value={"findCostTypeCons"})
    public AjaxJson findCostTypeCons(@RequestParam(value="fineCode") String fineCode, @RequestParam(value="cons") List<String> cons) {
        AjaxJson ajaxJson = new AjaxJson();
        Map<String, List<TtCostTypeFineDetailEntity>> map = this.ttCostTypeFineService.findCostTypeCons(fineCode, cons);
        ajaxJson.setMapT(map);
        return ajaxJson;
    }

    @GetMapping(value={"findListByCodes"})
    public AjaxJson<TtCostTypeCategoriesEntity> findListByCodes(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtCostTypeCategoriesEntity> costTypeCategoriesEntities = this.ttCostTypeCategoriesService.findListByCodes(codes);
        ajaxJson.setObjList(costTypeCategoriesEntities);
        return ajaxJson;
    }

    @GetMapping(value={"findFineListByCodes"})
    public AjaxJson<TtCostTypeFineEntity> findFineListByCodes(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtCostTypeFineEntity> costTypeFineEntities = this.ttCostTypeCategoriesService.findFineListByCodes(codes);
        ajaxJson.setObjList(costTypeFineEntities);
        return ajaxJson;
    }

    @GetMapping(value={"findCategoriesExtendByCode"})
    public AjaxJson<TtCostTypeCategoriesExtendEntity> findCategoriesExtendByCode(@RequestParam(value="codes") List<String> codes) {
        AjaxJson ajaxJson = new AjaxJson();
        List<TtCostTypeCategoriesExtendEntity> ttCostTypeCategoriesExtendEntities = this.categoriesExtendService.findCategoriesExtendByCode(codes);
        ajaxJson.setObjList(ttCostTypeCategoriesExtendEntities);
        return ajaxJson;
    }

    @PostMapping(value={"chooseTypeListPage"})
    public AjaxJson<TtCostTypeCategoriesEntity> chooseTypeListPage(@RequestBody TtCostTypeParamVo vo) {
        AjaxJson ajaxJson = new AjaxJson();
        PageInfo<TtCostTypeCategoriesEntity> pageInfo = this.ttCostTypeCategoriesService.chooseTypeListPage(vo.getEntity(), vo.getBudgetCodes(), vo.getPage());
        ajaxJson.setPageInfo(pageInfo);
        return ajaxJson;
    }
}

