/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.collectioninfo.service.impl;

import com.alibaba.fastjson.JSON;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.budget.attachment.dao.BudgetAttachmentDao;
import com.biz.eisp.budget.attachment.entity.BudgetAttachmentEntity;
import com.biz.eisp.budget.collectioninfo.dao.TtCollectionInfoDao;
import com.biz.eisp.budget.collectioninfo.entity.TtCollectionInfoEntity;
import com.biz.eisp.budget.collectioninfo.service.TtCollectionInfoService;
import com.biz.eisp.page.Page;
import com.biz.eisp.page.PageAutoHelperUtil;
import com.biz.eisp.service.BaseServiceImpl;
import com.biz.eisp.util.EnableModifyLog;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Service(value="ttCollectionInfoService")
@Transactional
public class TtCollectionInfoServiceImpl
extends BaseServiceImpl<TtCollectionInfoEntity>
implements TtCollectionInfoService {
    @Autowired
    private TtCollectionInfoDao ttCollectionInfoDao;
    @Autowired
    private BudgetAttachmentDao budgetAttachmentDao;

    @Override
    public PageInfo<TtCollectionInfoEntity> getMaiList(TtCollectionInfoEntity ttCollectionInfoEntity, Page page) {
        Example example = new Example(TtCollectionInfoEntity.class);
        example.setOrderByClause(" sort_num desc ");
        Example.Criteria criteria = example.createCriteria();
        if (StringUtil.isNotEmpty((CharSequence)ttCollectionInfoEntity.getCode())) {
            criteria.andEqualTo("code", (Object)ttCollectionInfoEntity.getCode());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCollectionInfoEntity.getName())) {
            criteria.andEqualTo("name", (Object)ttCollectionInfoEntity.getName());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCollectionInfoEntity.getCreateName())) {
            criteria.andEqualTo("createName", (Object)ttCollectionInfoEntity.getCreateName());
        }
        if (StringUtil.isNotEmpty((CharSequence)ttCollectionInfoEntity.getUpdateName())) {
            criteria.andEqualTo("updateName", (Object)ttCollectionInfoEntity.getUpdateName());
        }
        return PageAutoHelperUtil.generatePage(() -> this.ttCollectionInfoDao.selectByExample(example), (Page)page);
    }

    @Override
    public TtCollectionInfoEntity getEntity(String id) {
        TtCollectionInfoEntity entity = new TtCollectionInfoEntity();
        Example mExample = new Example(BudgetAttachmentEntity.class);
        Example.Criteria mCriteria = mExample.createCriteria();
        mCriteria.andEqualTo("businessKey", (Object)id);
        List budgetAttachmentEntitys = this.budgetAttachmentDao.selectByExample(mExample);
        entity = (TtCollectionInfoEntity)this.ttCollectionInfoDao.selectByPrimaryKey(id);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)budgetAttachmentEntitys)) {
            Object json = JSON.toJSON((Object)budgetAttachmentEntitys);
            entity.setMlamJson(json.toString());
        }
        return entity;
    }

    @Override
    @EnableModifyLog(name="\u65b0\u5efa", serviceclass=TtCollectionInfoServiceImpl.class)
    public AjaxJson save(TtCollectionInfoEntity ttCollectionInfoEntity, AjaxJson ajaxJson) {
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        int i = this.ttCollectionInfoDao.insertSelective(ttCollectionInfoEntity);
        if (i > 0 && StringUtil.isNotEmpty((CharSequence)ttCollectionInfoEntity.getMlamJson())) {
            List mlamEntityList = JSON.parseArray((String)ttCollectionInfoEntity.getMlamJson(), BudgetAttachmentEntity.class);
            ArrayList<BudgetAttachmentEntity> mlamList = new ArrayList<BudgetAttachmentEntity>();
            for (BudgetAttachmentEntity mlamEntity : mlamEntityList) {
                if (StringUtil.isEmpty((String)mlamEntity.getVurlPath())) continue;
                mlamEntity.setBusinessKey(ttCollectionInfoEntity.getId());
                mlamList.add(mlamEntity);
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(mlamList)) {
                this.budgetAttachmentDao.insertList(mlamList);
            }
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u7f16\u8f91", serviceclass=TtCollectionInfoServiceImpl.class)
    public AjaxJson update(TtCollectionInfoEntity ttCollectionInfoEntity, AjaxJson ajaxJson) {
        if (!ajaxJson.isSuccess()) {
            return ajaxJson;
        }
        int i = this.ttCollectionInfoDao.updateByPrimaryKeySelective(ttCollectionInfoEntity);
        if (i > 0) {
            Example mExample = new Example(BudgetAttachmentEntity.class);
            Example.Criteria mCriteria = mExample.createCriteria();
            mCriteria.andEqualTo("businessKey", (Object)ttCollectionInfoEntity.getId());
            this.budgetAttachmentDao.deleteByExample(mExample);
            if (StringUtil.isNotEmpty((CharSequence)ttCollectionInfoEntity.getMlamJson())) {
                List mlamEntityList = JSON.parseArray((String)ttCollectionInfoEntity.getMlamJson(), BudgetAttachmentEntity.class);
                ArrayList<BudgetAttachmentEntity> mlamList = new ArrayList<BudgetAttachmentEntity>();
                for (BudgetAttachmentEntity mlamEntity : mlamEntityList) {
                    if (StringUtil.isEmpty((String)mlamEntity.getVurlPath())) continue;
                    mlamEntity.setBusinessKey(ttCollectionInfoEntity.getId());
                    mlamList.add(mlamEntity);
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(mlamList)) {
                    this.budgetAttachmentDao.insertList(mlamList);
                }
            }
        }
        return ajaxJson;
    }

    @Override
    @EnableModifyLog(name="\u5220\u9664", serviceclass=TtCollectionInfoServiceImpl.class)
    public boolean delete(String id) {
        int i = this.ttCollectionInfoDao.deleteByPrimaryKey(id);
        return i > 0;
    }
}

