/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.budget.config.entity.TtBudgetSubjectsEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesFineEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtBudgetSubjectsService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesFineService;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.budget.config.vo.TtCostTypeFineVo;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.biz.eisp.tools.DictUtil;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BUDGET-\u6d3b\u52a8\u7ec6\u7c7b"}, description="BUDGET-\u6d3b\u52a8\u7ec6\u7c7b")
@RestController
@RequestMapping(value={"/ttCostTypeFineController"})
public class TtCostTypeFineController {
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;
    @Autowired
    private TtCostTypeCategoriesFineService ttCostTypeCategoriesFineService;
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private TtBudgetSubjectsService ttBudgetSubjectsService;

    @ApiOperation(value="\u6839\u636e\u6d3b\u52a8\u7ec6\u7c7bid\u6216\u8005\u7ec6\u7c7b\u7f16\u7801\u67e5\u8be2\u6d3b\u52a8\u7ec6\u7c7b\u8be6\u60c5", notes="\u6839\u636e\u6d3b\u52a8\u7ec6\u7c7bid\u6216\u8005\u7ec6\u7c7b\u7f16\u7801\u67e5\u8be2\u6d3b\u52a8\u7ec6\u7c7b\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"getTtCostTypeFineByIdOrCode"})
    public AjaxJson<TtCostTypeFineVo> getTtCostTypeFineByIdOrCode(@RequestParam(value="id", required=false) String id, @RequestParam(value="fineCode", required=false) String fineCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtCostTypeFineVo ttCostTypeFineVo = new TtCostTypeFineVo();
        TtCostTypeFineEntity costTypeFineEntity = this.ttCostTypeFineService.getFineEntity(id, fineCode);
        ArrayList ttCostTypeCategoriesFineEntities = this.ttCostTypeCategoriesFineService.findListByfineCodeOrcategoriesCode(costTypeFineEntity.getFineCode(), null);
        ttCostTypeCategoriesFineEntities = ttCostTypeCategoriesFineEntities == null ? new ArrayList() : ttCostTypeCategoriesFineEntities;
        ttCostTypeFineVo.setEntity(costTypeFineEntity);
        List<String> categoriesCodes = ttCostTypeCategoriesFineEntities.stream().map(TtCostTypeCategoriesFineEntity::getCategoriesCode).distinct().collect(Collectors.toList());
        List<TtCostTypeCategoriesEntity> ttCostTypeCategoriesEntities = this.ttCostTypeCategoriesService.findListByCodes(categoriesCodes);
        List<String> budgetSubjectsCodes = ttCostTypeCategoriesEntities.stream().map(TtCostTypeCategoriesEntity::getBudgetSubjectsCode).distinct().collect(Collectors.toList());
        List<TtBudgetSubjectsEntity> subjectsEntities = this.ttBudgetSubjectsService.getBudgetSubjects(budgetSubjectsCodes);
        ttCostTypeFineVo.setTtBudgetSubjectsEntities(subjectsEntities);
        ajaxJson.setObj((Object)ttCostTypeFineVo);
        return ajaxJson;
    }

    @ApiOperation(value="\u6839\u636e\u5ba2\u6237\u5206\u7ec4\u67e5\u8be2\u6d3b\u52a8\u7ec6\u7c7b\u5217\u8868", notes="\u6839\u636e\u5ba2\u6237\u5206\u7ec4\u67e5\u8be2\u6d3b\u52a8\u7ec6\u7c7b\u5217\u8868", httpMethod="POST")
    @PostMapping(value={"getCostTypeFineListByCustGruop"})
    public DataGrid getCostTypeFineListByCustGruop(HttpServletRequest request, String custGroup, TtCostTypeFineEntity ttCostTypeFineEntity) {
        EuPage page = new EuPage(request);
        custGroup = StringUtil.isBlank((CharSequence)custGroup) ? "_" : custGroup;
        List knlDictDataEntities = DictUtil.getDictList((String)"subjects_type");
        knlDictDataEntities = knlDictDataEntities == null ? new ArrayList() : knlDictDataEntities;
        ArrayList<String> codes = new ArrayList<String>();
        for (KnlDictDataEntity item : knlDictDataEntities) {
            String custGroupTemp;
            Map map = item.getExtendMap();
            map = map == null ? new HashMap() : map;
            if (!map.containsKey("custGroup") || !StringUtil.isNotBlank((CharSequence)(custGroupTemp = map.get("custGroup") == null ? "" : map.get("custGroup").toString())) || !custGroupTemp.equals(custGroup)) continue;
            codes.add(item.getDictCode());
        }
        List<TtBudgetSubjectsEntity> ttBudgetSubjectsEntities = this.ttBudgetSubjectsService.getBudgetSubjectsBySubjectsType(codes);
        List<String> budgetSubjectsCodes = ttBudgetSubjectsEntities.stream().map(TtBudgetSubjectsEntity::getBudgetSubjectsCode).distinct().collect(Collectors.toList());
        PageInfo<TtCostTypeFineEntity> pageInfo = this.ttCostTypeFineService.getTtCostTypeFineEntityListByBudgetSubjectsCodes(ttCostTypeFineEntity, budgetSubjectsCodes, (Page)page);
        return new DataGrid(pageInfo);
    }
}

