/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.budget.config.controller;

import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.pojo.ConstantEnum;
import com.biz.eisp.budget.config.entity.TtCostTypeCategoriesEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineDetailEntity;
import com.biz.eisp.budget.config.entity.TtCostTypeFineEntity;
import com.biz.eisp.budget.config.service.TtCostTypeCategoriesService;
import com.biz.eisp.budget.config.service.TtCostTypeFineService;
import com.biz.eisp.page.EuPage;
import com.biz.eisp.page.Page;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttCostTypeController"})
public class TtCostTypeController {
    @Autowired
    private TtCostTypeCategoriesService ttCostTypeCategoriesService;
    @Autowired
    private TtCostTypeFineService ttCostTypeFineService;

    @GetMapping(value={"getCategoriesEntity"})
    public AjaxJson<TtCostTypeCategoriesEntity> getCategoriesEntity(@RequestParam(value="id", required=false) String id, @RequestParam(value="categoriesCode", required=false) String categoriesCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtCostTypeCategoriesEntity entity = this.ttCostTypeCategoriesService.getCategoriesEntity(id, categoriesCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @GetMapping(value={"getFineEntity"})
    public AjaxJson<TtCostTypeFineEntity> getFineEntity(@RequestParam(value="id", required=false) String id, @RequestParam(value="fineCode", required=false) String fineCode) {
        AjaxJson ajaxJson = new AjaxJson();
        TtCostTypeFineEntity entity = this.ttCostTypeFineService.getFineEntity(id, fineCode);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"getCategoriesListPage"})
    @ResponseBody
    public DataGrid getCategoriesListPage(HttpServletRequest request, TtCostTypeCategoriesEntity ttCostTypeCategoriesEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtCostTypeCategoriesEntity> pageInfo = this.ttCostTypeCategoriesService.getMaiList(ttCostTypeCategoriesEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getFineListPage"})
    @ResponseBody
    public DataGrid getFineListPage(HttpServletRequest request, TtCostTypeFineEntity ttCostTypeFineEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtCostTypeFineEntity> pageInfo = this.ttCostTypeFineService.getMaiList(ttCostTypeFineEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"stopCategories"})
    @ResponseBody
    public AjaxJson deleteCategories(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttCostTypeCategoriesService.stopOrstartCategories(id, ajaxJson, ConstantEnum.StatusEnum.DELETE.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"startCategories"})
    @ResponseBody
    public AjaxJson startCategories(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttCostTypeCategoriesService.stopOrstartCategories(id, ajaxJson, ConstantEnum.StatusEnum.NEW.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateCategories"})
    @ResponseBody
    public AjaxJson saveOrUpdateCategories(HttpServletRequest request, TtCostTypeCategoriesEntity categoriesEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        if (StringUtil.isEmpty((String)categoriesEntity.getId())) {
            ajaxJson = this.ttCostTypeCategoriesService.save(categoriesEntity, ajaxJson);
        } else {
            TtCostTypeCategoriesEntity entity = this.ttCostTypeCategoriesService.getCategoriesEntity(categoriesEntity.getId(), null);
            categoriesEntity.setEnableStatus(entity.getEnableStatus());
            ajaxJson = this.ttCostTypeCategoriesService.update(categoriesEntity, ajaxJson);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"stopFine"})
    @ResponseBody
    public AjaxJson stopFine(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttCostTypeFineService.stopOrStartFine(id, ajaxJson, ConstantEnum.StatusEnum.DELETE.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"startFine"})
    @ResponseBody
    public AjaxJson startFine(HttpServletRequest request, @RequestBody String[] ids) {
        AjaxJson ajaxJson = new AjaxJson();
        int errorCount = 0;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\u5f85\u64cd\u4f5c\u6570\u636e").append(ids.length).append("\u6761");
        for (String id : ids) {
            try {
                ajaxJson = this.ttCostTypeFineService.stopOrStartFine(id, ajaxJson, ConstantEnum.StatusEnum.NEW.getValue());
                if (ajaxJson.isSuccess()) continue;
                ++errorCount;
            }
            catch (Exception e) {
                ++errorCount;
                e.printStackTrace();
            }
        }
        stringBuffer.append("\uff0c\u5931\u8d25").append(errorCount).append("\u6761");
        if (errorCount == 0) {
            ajaxJson.setSuccessMsg("\u64cd\u4f5c\u6210\u529f");
        } else {
            ajaxJson.setSuccessMsg(stringBuffer.toString());
        }
        return ajaxJson;
    }

    @RequestMapping(value={"saveOrUpdateFine"})
    @ResponseBody
    public AjaxJson saveOrUpdateFine(HttpServletRequest request, TtCostTypeFineEntity costTypeFineEntity) {
        AjaxJson ajaxJson = new AjaxJson();
        ajaxJson = StringUtil.isEmpty((String)costTypeFineEntity.getId()) ? this.ttCostTypeFineService.save(costTypeFineEntity, ajaxJson) : this.ttCostTypeFineService.update(costTypeFineEntity, ajaxJson);
        return ajaxJson;
    }

    @ResponseBody
    @RequestMapping(value={"deleteFine"})
    public AjaxJson deleteFine(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttCostTypeFineService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"getSelectFinePage"})
    @ResponseBody
    public DataGrid getSelectFinePage(HttpServletRequest request, TtCostTypeFineEntity ttCostTypeFineEntity) {
        EuPage page = new EuPage(request);
        PageInfo<TtCostTypeFineEntity> pageInfo = this.ttCostTypeFineService.getSelectFinePage(ttCostTypeFineEntity, (Page)page);
        return new DataGrid(pageInfo);
    }

    @RequestMapping(value={"getFineListByCategories"})
    @ResponseBody
    public DataGrid getFineListByCategories(HttpServletRequest request, String code) {
        PageInfo pageInfo = new PageInfo();
        List<TtCostTypeFineEntity> list = this.ttCostTypeFineService.getFinesByCategoriesCode(code);
        pageInfo.setList(list);
        return new DataGrid(pageInfo);
    }

    @ResponseBody
    @RequestMapping(value={"deleteCategories"})
    public AjaxJson deleteCategories(String ids) {
        AjaxJson j = new AjaxJson();
        try {
            if (!this.ttCostTypeCategoriesService.delete(ids)) {
                j.setSuccess(false);
                j.setMsg("\u5220\u9664\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return j;
    }

    @ResponseBody
    @RequestMapping(value={"checkProductByFineCode"})
    public AjaxJson checkProductByFineCode(@RequestBody String[] codes) {
        AjaxJson ajaxJson = new AjaxJson();
        boolean flag = this.ttCostTypeFineService.checkProductByFineCode(new ArrayList<String>(Arrays.asList(codes)));
        if (flag) {
            ajaxJson.setType(Integer.valueOf(1));
        } else {
            ajaxJson.setType(Integer.valueOf(0));
        }
        return ajaxJson;
    }

    @ApiOperation(value="\u6d3b\u52a8\u7ec6\u7c7b\u9644\u5c5e\u652f\u4ed8\u65b9\u5f0f", notes="\u6839\u636e\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u7801\u67e5\u8be2\u6d3b\u52a8\u7ec6\u7c7b\u9644\u5c5e\u652f\u4ed8\u65b9\u5f0f", httpMethod="GET")
    @GetMapping(value={"getFinePayType"})
    public AjaxJson<TtCostTypeFineDetailEntity> getFinePayType(@RequestParam(value="fineCode") String fineCode) {
        AjaxJson ajaxJsonAjaxJson = new AjaxJson();
        ArrayList list = new ArrayList();
        ArrayList<String> pay = new ArrayList<String>();
        pay.add(ConstantEnum.FIELD_NAME.pay_type.name());
        if (StringUtil.isNotBlank((CharSequence)fineCode)) {
            HashMap map = this.ttCostTypeFineService.findCostTypeCons(fineCode, pay);
            HashMap hashMap = map = map == null ? new HashMap() : map;
            if (map.containsKey(ConstantEnum.FIELD_NAME.pay_type.name())) {
                list.addAll((Collection)map.get(ConstantEnum.FIELD_NAME.pay_type.name()));
            }
        }
        ajaxJsonAjaxJson.setList(list);
        return ajaxJsonAjaxJson;
    }
}

