/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.account.controller;

import com.biz.eisp.account.entity.TtAccountInvoiceEntity;
import com.biz.eisp.account.service.TtAccountInvoiceService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.invoice.vo.AiInvoiceDataItemVo;
import com.biz.eisp.invoice.vo.InvoiceVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ttAccountInvoiceController"})
public class TtAccountInvoiceController {
    @Autowired
    private TtAccountInvoiceService ttAccountInvoiceService;

    @GetMapping(value={"getEntity"})
    public AjaxJson<TtAccountInvoiceEntity> getEntity(@RequestParam(value="id") String id) {
        AjaxJson ajaxJson = new AjaxJson();
        TtAccountInvoiceEntity entity = this.ttAccountInvoiceService.getEntity(id);
        ajaxJson.setObj((Object)entity);
        return ajaxJson;
    }

    @RequestMapping(value={"getInvoice"})
    @ResponseBody
    public AjaxJson getInvoice(@RequestBody List<String> arr) {
        AjaxJson j = new AjaxJson();
        ArrayList<TtAccountInvoiceEntity> invoiceVos = new ArrayList<TtAccountInvoiceEntity>();
        if (CollectionUtil.listNotEmptyNotSizeZero(arr)) {
            for (String str : arr) {
                InvoiceVo invoiceVo = this.ttAccountInvoiceService.getInvoice(str);
                TtAccountInvoiceEntity ttAccountInvoiceEntity = new TtAccountInvoiceEntity();
                List itemList = invoiceVo.getItemList();
                ttAccountInvoiceEntity.setInvoiceCode(invoiceVo.getInvoiceCode());
                ttAccountInvoiceEntity.setInvoiceAmount(invoiceVo.getTotalAmount());
                BigDecimal bigDecimal = new BigDecimal(0);
                if (CollectionUtil.listNotEmptyNotSizeZero((List)itemList)) {
                    ttAccountInvoiceEntity.setTaxCode(((AiInvoiceDataItemVo)itemList.get(0)).getTaxRate());
                    for (AiInvoiceDataItemVo aiInvoiceDataItemVo : itemList) {
                        bigDecimal = bigDecimal.add(aiInvoiceDataItemVo.getTax());
                    }
                } else {
                    ttAccountInvoiceEntity.setNotes(invoiceVo.getErrMessage());
                }
                ttAccountInvoiceEntity.setTaxAmount(bigDecimal);
                invoiceVos.add(ttAccountInvoiceEntity);
            }
        }
        j.setObjList(invoiceVos);
        return j;
    }
}

