/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@ConfigurationProperties(prefix="jwt")
@Component
public class JwtUtils {
    private static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    private String secret;
    private long expire;
    private String header;

    public String generateToken(String userId) {
        Date nowDate = new Date();
        Date expireDate = new Date(nowDate.getTime() + this.expire * 1000L);
        return Jwts.builder().setHeaderParam("typ", (Object)"JWT").setSubject(userId).setIssuedAt(nowDate).setExpiration(expireDate).signWith(SignatureAlgorithm.HS256, this.secret).compact();
    }

    public Claims getClaimByToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            log.debug("token\u9a8c\u8bc1\u9519\u8bef,\u8bf7\u91cd\u65b0\u767b\u9646 ", (Throwable)e);
            return null;
        }
    }

    public String getUserId(String token) {
        Claims claims = this.getClaimByToken(token);
        return claims.getSubject();
    }

    public boolean isTokenExpired(Date expiration) {
        return expiration.before(new Date());
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public long getExpire() {
        return this.expire;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }
}

