/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import jodd.io.StringInputStream;

public class StreamUtils {
    static final int BUFFER_SIZE = 4096;

    public static String InputStreamTOString(InputStream in) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        String string = null;
        int count = 0;
        try {
            while ((count = in.read(data, 0, 4096)) != -1) {
                outStream.write(data, 0, count);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        data = null;
        try {
            string = new String(outStream.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return string;
    }

    public static String InputStreamTOString(InputStream in, String encoding) {
        String string = null;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        int count = -1;
        try {
            while ((count = in.read(data, 0, 4096)) != -1) {
                outStream.write(data, 0, count);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        data = null;
        try {
            string = new String(outStream.toByteArray(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return string;
    }

    public static InputStream StringTOInputStream(String in) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(in.getBytes("UTF-8"));
        return is;
    }

    public static byte[] StringTObyte(String in) {
        byte[] bytes = null;
        try {
            bytes = StreamUtils.InputStreamTOByte(StreamUtils.StringTOInputStream(in));
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static byte[] InputStreamTOByte(InputStream in) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        int count = -1;
        while ((count = in.read(data, 0, 4096)) != -1) {
            outStream.write(data, 0, count);
        }
        data = null;
        return outStream.toByteArray();
    }

    public static InputStream byteTOFInputStream(byte[] in) throws Exception {
        StringInputStream is = new StringInputStream(StreamUtils.InputStreamTOString(StreamUtils.byteTOInputStream(in)));
        return is;
    }

    public static InputStream byteTOInputStream(byte[] in) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(in);
        return is;
    }

    public static String byteTOString(byte[] in) {
        InputStream is = null;
        try {
            is = StreamUtils.byteTOInputStream(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (is != null) {
            return StreamUtils.InputStreamTOString(is, "UTF-8");
        }
        return "";
    }

    public static String getString(String in) {
        String is = null;
        try {
            is = StreamUtils.byteTOString(StreamUtils.StringTObyte(in));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return is;
    }

    public byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] b = new byte[4096];
        int len = 0;
        while ((len = is.read(b, 0, 4096)) != -1) {
            baos.write(b, 0, len);
        }
        baos.flush();
        byte[] bytes = baos.toByteArray();
        return bytes;
    }

    public static FileInputStream getFileInputStream(String filepath) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filepath);
        }
        catch (FileNotFoundException e) {
            System.out.print("\u9519\u8bef\u4fe1\u606f:\u6587\u4ef6\u4e0d\u5b58\u5728");
            e.printStackTrace();
        }
        return fileInputStream;
    }

    public static FileInputStream getFileInputStream(File file) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            System.out.print("\u9519\u8bef\u4fe1\u606f:\u6587\u4ef6\u4e0d\u5b58\u5728");
            e.printStackTrace();
        }
        return fileInputStream;
    }

    public static FileOutputStream getFileOutputStream(File file, boolean append) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, append);
        }
        catch (FileNotFoundException e) {
            System.out.print("\u9519\u8bef\u4fe1\u606f:\u6587\u4ef6\u4e0d\u5b58\u5728");
            e.printStackTrace();
        }
        return fileOutputStream;
    }

    public static FileOutputStream getFileOutputStream(String filepath, boolean append) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filepath, append);
        }
        catch (FileNotFoundException e) {
            System.out.print("\u9519\u8bef\u4fe1\u606f:\u6587\u4ef6\u4e0d\u5b58\u5728");
            e.printStackTrace();
        }
        return fileOutputStream;
    }

    public static File getFile(String filepath) {
        return new File(filepath);
    }

    public static ByteArrayOutputStream getByteArrayOutputStream() {
        return new ByteArrayOutputStream();
    }
}

