/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.page;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class Page
extends HashMap<String, String>
implements Serializable {
    public static final String DEFAULT_PAGENAME = "easyui";
    public static final String DEFAULT_PAGESIZE = "15";
    public static final String DEFAULT_EXPORTSIZE = "60000";
    public static final String DEFAULT_PAGE = "1";
    public static final String PAGE = "page";
    public static final String ROWS = "rows";
    public static final String TOTAL = "total";
    public static final String SORT = "sort";
    public static final String TOTAL_PAGE_COUNT = "totalPageCount";
    public static final String DIR = "dir";
    public static final String DEFAULT_SORT = "defaultSort";
    public static final String USER_ID_KEY = "_userId";
    public static final String EMP_ID_KEY = "_empId";
    public static final String EMP_SUBCODE_KEY = "_empSubCode";
    public static final String EMP_LEVELCODE_KEY = "_empLevelCode";
    public static final String PARENT_EMP_ID_KEY = "_parentEmpId";
    public static final String PARENT_EMP_SUBCODE_KEY = "_parentEmpSubCode";
    public static final String PARENT_EMP_lEVELCODE_KEY = "_parentEmpLevelCode";
    public static final String POSITION_ID_KEY = "_empId";
    public static final String POSITION_SUBCODE_KEY = "_positionSubCode";
    public static final String POSITION_LEVELCODE_KEY = "_positionLevelCode";
    public static final String PARENT_POSITION_ID_KEY = "_parentPositionId";
    public static final String PARENT_POSITION_SUBCODE_KEY = "_parentPositionSubCode";
    public static final String PARENT_POSITION_lEVELCODE_KEY = "_parentPositionLevelCode";
    public static final String DEPART_SUBCODE_KEY = "_orgDepartCode";
    public static final String DEPART_ID_KEY = "_departId";
    public static final String PARENT_DEPART_ID_KEY = "_parentDepartId";
    public static final String PARENT_DEPART_SUBCODE_KEY = "_parentDepartSubCode";
    public static final String EMP_AUTH_KEY = "_empAuth";
    public static final String ORG_SUBCODE_KEY = "_orgSubCode";
    public static final String ORG_ID_KEY = "_orgId";
    public static final String ORG_AUTH_KEY = "_orgAuth";
    public static final String POSITION_AUTH_KEY = "_positionAuth";
    public static final String POSITION_CASCADE_AUTH_KEY = "_positionCascadeAuth";
    public static final String DEPART_AUTH_KEY = "_departAuth";
    public static final String DATA_AUTH = "_dataAuth";
    public static final String DATA_AUTH_LEVEL = "_dataAuthLevel";
    public static final String AUTH_PREFIX = "_authPrefix";
    protected String pageName;
    protected boolean paging = true;

    public Page() {
        this.pageName = DEFAULT_PAGENAME;
        this.initParams();
    }

    public Page(String page, String rows) {
        this.pageName = DEFAULT_PAGENAME;
        this.initParams();
        this.put(ROWS, rows);
        this.put(PAGE, page);
    }

    public Page(Map<String, Object> pageMap) {
        this.pageName = DEFAULT_PAGENAME;
        this.initParams();
        String page = DEFAULT_PAGE;
        String rows = DEFAULT_PAGESIZE;
        if (pageMap != null) {
            page = pageMap.get(PAGE) == null ? DEFAULT_PAGE : pageMap.get(PAGE).toString();
            rows = pageMap.get(ROWS) == null ? DEFAULT_PAGESIZE : pageMap.get(ROWS).toString();
        }
        this.setPage(page);
        this.setRows(rows);
    }

    public Page(HttpServletRequest request) {
        this(request, DEFAULT_PAGENAME);
    }

    public Page(HttpServletRequest request, String pageName) {
        this.pageName = pageName;
        this.initParams();
        this.initParams(request);
    }

    public void initParams() {
        this.put(PAGE, DEFAULT_PAGE);
        this.put(ROWS, DEFAULT_PAGESIZE);
    }

    public void setPage(String page) {
        this.put(PAGE, page);
    }

    public void setRows(String rows) {
        this.put(ROWS, rows);
    }

    public void initParams(HttpServletRequest request) {
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            this.put(name, request.getParameter(name).replaceAll("'", "''"));
        }
    }

    public int getPageNo() {
        int page = this.getInt(PAGE);
        int rows = this.getInt(ROWS);
        return (page - 1) * rows;
    }

    public int getInt(String name) {
        String intstr = (String)this.get(name);
        if (StringUtils.isEmpty((CharSequence)intstr) || "undefined".equals(intstr)) {
            return 0;
        }
        return intstr != null ? Integer.parseInt(intstr) : 0;
    }

    public long getLong(String name) {
        return this.get(name) != null ? Long.parseLong((String)this.get(name)) : 0L;
    }

    public static void setValue(HttpServletRequest request, String pageName, String name, String value) {
        Map page = (Map)request.getSession().getAttribute(pageName);
        if (page != null) {
            page.put(name, value);
        }
    }

    public static void setValue(HttpServletRequest request, String name, String value) {
        Page.setValue(request, DEFAULT_PAGENAME, name, value);
    }

    public void compute() {
        int pageSize;
        int totalCount = this.getInt(TOTAL);
        this.put(TOTAL_PAGE_COUNT, totalCount % (pageSize = this.getInt(PAGE)) == 0 ? String.valueOf(totalCount / pageSize) : String.valueOf(totalCount / pageSize + 1));
    }

    public static String getValue(HttpServletRequest request, String pageName, String name) {
        Map page = (Map)request.getSession().getAttribute(pageName);
        if (page != null) {
            return (String)page.get(name);
        }
        return null;
    }

    public static String getValue(HttpServletRequest request, String name) {
        return Page.getValue(request, DEFAULT_PAGENAME, name);
    }

    public boolean isPaging() {
        return this.paging;
    }

    public void setPaging(boolean paging) {
        this.paging = paging;
    }

    public String getPage() {
        return (String)this.get(PAGE);
    }

    public String getRows() {
        return (String)this.get(ROWS);
    }
}

