/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.util;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.util.DictExcelSelectVo;
import com.biz.eisp.dict.entity.KnlDictDataEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictSheetWriteHandler
implements SheetWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(DictSheetWriteHandler.class);
    private List<List<String>> vals = new ArrayList<List<String>>();
    private List<DictExcelSelectVo> dictExcelSelectVos = new ArrayList<DictExcelSelectVo>();

    public DictSheetWriteHandler() {
    }

    public DictSheetWriteHandler(List<List<String>> vals, List<DictExcelSelectVo> dictExcelSelectVos) {
        vals = vals == null ? new ArrayList<List<String>>() : vals;
        this.vals = vals;
        this.dictExcelSelectVos = dictExcelSelectVos;
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        if (CollectionUtil.listEmpty(this.dictExcelSelectVos)) {
            return;
        }
        for (DictExcelSelectVo item : this.dictExcelSelectVos) {
            CellRangeAddressList cellRangeAddressList = new CellRangeAddressList();
            CellRangeAddress cra = new CellRangeAddress(1, this.vals.size(), item.getCol()[0], item.getCol()[1]);
            cellRangeAddressList.addCellRangeAddress(cra);
            DataValidationHelper helper = writeSheetHolder.getSheet().getDataValidationHelper();
            List<String> dataVals = item.getDictDataEntities().stream().map(KnlDictDataEntity::getDictValue).collect(Collectors.toList());
            DataValidationConstraint constraint = helper.createExplicitListConstraint(dataVals.toArray(new String[dataVals.size()]));
            DataValidation dataValidation = helper.createValidation(constraint, cellRangeAddressList);
            writeSheetHolder.getSheet().addValidationData(dataValidation);
        }
    }
}

